﻿//Programed by NAS6
//writingnumber.js

/*
	public ref class WNum
	{
		// TODO: このクラスの、ユーザーのメソッドをここに追加してください。
		private:
			
			//oprator-()内部関数
			static WNum^ opr_mns(WNum^ me);
			//oprator+()内部関数
			static WNum^ opr_add(WNum^ me,WNum^ obj);
			//oprator-()内部関数
			static WNum^ opr_sub(WNum^ me,WNum^ obj);
			//oprator*()内部関数
			static WNum^ opr_mul(WNum^ me,WNum^ obj);
			//oprator/()内部関数
			static WNum^ opr_div(WNum^ me,WNum^ obj,WNum% mod);
			
	

			//ret:a^n内部関数
			static WNum^ power(WNum^ a,WNum^ n);
			//ret:a^(1/n)内部関数
			static WNum^ nthroot(WNum^ a,WNum^ n);
			//str:String10進数値,ret:10進数値
			static int xs210(String^ str);
			//n:10進数値,ret:String10進数値
			static String^ x102s(int n);
			//str:Stringn進数値,n:n進数,ret:String10進数値
			static String^ xn210(String^ str,int n);
			//str:String10進数値,n:n進数,ret:Stringn進数値
			static String^ x102n(String^ str,int n);
			//ret:m_fp計算
			static int compFP(WNum^ me);
			//obj:WNumn進数値,n:n進数,ret:WNum10進数値
			static WNum^ xn210(WNum^ obj,int n);
			//obj:WNum10進数値,n:n進数,ret:WNumn進数値
			static WNum^ x102n(WNum^ obj,int n);
			//a:WNum数値,ret:wchar_t文字
			static wchar_t wnum2char(WNum^ a);
			//a:WNum数値,ret:int数値
			static int wnum2int(WNum^ a);
			//a:int数値,ret:wchar_t文字
			static wchar_t int2char(int a);
			//c:wchar_t文字,ret:int数値
			static int char2int(wchar_t c);
			//WNum::呼び出しでm_strを正規化
			static void tostr(WNum^ me);
			//WNum::呼び出しでm_strから正規化
			static void fromstr(WNum^ me);
			//
			static WNum^ tmpsub(WNum^ me,int n,int p,int fp,int f);
	

		public:
			int m_n;				//基数
			int m_f;				//桁
			int m_s;				//符号
			int m_p;				//小数点の位置
			int m_fp;				//小数点精度
			int m_ef;				//エラーフラグ(bit立て)
									//0x0　　：正常
									//0x1　　：エラー
									//0x100　：虚数解

			String^ m_str;			//String数値


			vector<int>^ m_nf;		//数値データ
			static WNum^ m_xor_nn;
			static WNum^ m_xor_ee;
			static int m_xor_fp;
		public:
	




			//コンストラクタ
			WNum operator=(WNum obj);
			WNum^ operator=(WNum^ obj);
			WNum opr_eql(WNum^ obj);
			WNum^ opr_eql(WNum obj);
			WNum(WNum% obj);
			WNum(WNum^ obj);
		

			WNum();
			WNum(int n);
			
			//n:基数,str:String数値,fp:少数点精度
			//str format:["+/-"]"X..."[".Y..."]"[#["+/-"]"E..."]"
			//+/-:符号,X...:整数部,.Y...:小数部,E...:指数部
			WNum(int n,String^ str,int fp);
			//str:String数値
			//str format:["+/-"]"X..."[".Y..."]"[#["+/-"]"E..."]""(Z)"
			//+/-:符号,X...:整数部,.Y...:小数部(これでm_fp決定),E...:指数部,(Z):基数
			WNum(String^ str);
			//str:String数値,fp:少数点精度,bbb:自動拡張fp
			//str format:["+/-"]"X..."[".Y..."]"[#["+/-"]"E..."]""(Z)"
			//+/-:符号,X...:整数部,.Y...:小数部,E...:指数部,(Z):基数
			WNum(String^ str,int fp,bool bbb);



			//累乗定数
			static void setxorcnst(WNum^ nn,WNum^ ee,int fp){m_xor_nn=nn;m_xor_ee=ee;m_xor_fp=fp;}
			//エラー(bit立て)
			//0x0　　：正常
			//0x1　　：エラー
			//0x100　：虚数解
			static WNum^ err(int i){
				WNum^ zero=gcnew WNum(10,L"0",0);
				zero->m_ef=i;
				return zero;
			}
	
			//fpEPSILON
			static WNum^ EPSILON(int fp,int mfp){
				String^ ss=gcnew String(L"0.");
				for(int i=0;i<fp-1;i++)ss+=L"0";
				ss+=L"1";
				return gcnew WNum(10,ss,mfp);
			}
			static WNum^ SQRT_EPSILON(int fp,int mfp){WNum^ a=gcnew WNum(10,L"0.5",mfp);return EPSILON(fp,mfp)^a;}
			static WNum^ SQRT_SQRT_EPSILON(int fp,int mfp){WNum^ a=gcnew WNum(10,L"0.25",mfp);return EPSILON(fp,mfp)^a;}


			static WNum^ sgn(WNum^ me){return gcnew WNum(me->m_n,String::Format(L"{0}",me->m_s),me->m_fp);}

			//operator overload
			static bool operator==(WNum^ me, WNum^ obj);
			static bool operator!=(WNum^ me, WNum^ obj);
			static bool operator<(WNum^ me, WNum^ obj);
			static bool operator<=(WNum^ me, WNum^ obj);
			static bool operator>(WNum^ me, WNum^ obj);
			static bool operator>=(WNum^ me, WNum^ obj);
			//.111...or.222...etc.は内部で(1/(m_n-1))or(2/(m_n-1))etc.として計算
			static WNum^ operator-(WNum^ me);
			static WNum^ operator+(WNum^ me, WNum^ obj);
			static WNum^ operator-(WNum^ me, WNum^ obj);
			static WNum^ operator*(WNum^ me, WNum^ obj);
			static WNum^ operator/(WNum^ me, WNum^ obj);
			static WNum^ operator%(WNum^ me, WNum^ obj);
			static WNum^ opr_xor(WNum^ me, WNum^ obj);
			static WNum^ opr_xor(WNum^ me, WNum^ obj,WNum^ n,WNum^ eps,int fp);
			static WNum^ operator^(WNum^ me, WNum^ obj);
		
			//ret:String数値
			//str format:["+/-"]"X..."[".Y..."]"(Z)"
			//+/-:符号,X...:整数部,.Y...:小数部,(Z):基数
			static String^ str(WNum^ me);
			//ret:String指数表示数値
			//str format:["+/-"]"X..."[".Y..."]"#["+/-"]"E..."""(Z)"
			//+/-:符号,X...:整数部,.Y...:小数部,E...:指数部,(Z):基数
			static String^ strE(WNum^ me);





			//ret:有効桁取得
			static WNum^ getValid(WNum^ me);
			//ret:桁取得
			static WNum^ getFigure(WNum^ me);
			//ret:小数部まで整数にして取得
			static WNum^ getDecimalInt(WNum^ me);
			//ret:整数部取得
			static WNum^ getInteger(WNum^ me);
			//ret:小数部取得
			static WNum^ getDecimal(WNum^ me);
			//n:基数,ret:基数変換
			static WNum^ cardinal(WNum^ me,int n);


			//ret:a,b最大公約数
			static WNum^ gcd(WNum^ a,WNum^ b);
			//ret:a,b最大公約数
			static WNum^ gcd2(WNum^ a, WNum^ b);
			//ret:a,b最大公約数
			static WNum^ gcd3(WNum^ a, WNum^ b);
			//ret:a,b最小公倍数
			static WNum^ lcm(WNum^ a,WNum^ b);
			//分数化:ret:true:循環小数あり,a:実数,a=b/c,f:true:強制分数化
			static bool fractional(WNum^ a,WNum% b,WNum% c,bool f);
			//bc間の比率
			static WNum^ ratio(WNum^ a,WNum^ b,WNum^ bb,WNum^ c,WNum^ cc);
			//ret:階乗,x:x
			static WNum^ factorial(WNum^ x);
			//ret:階乗,x:x,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi,ne:ne
			static WNum^ factorial(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi,WNum^ ne);
			//ret:階乗,x:x,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi,ne:ne
			static WNum^ factorial2(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi,WNum^ ne);

			//WNum::呼び出しで正規化
			static void normalization(WNum^ me);
			
			//ret:abs
			static WNum^ abs(WNum^ me);


			//ret:PI,fp:小数点精度
			static WNum^ calcPI(int fp);
			//ret:PI,x:総和の範囲,n:n個のマクローリン展開,eps:精度,fp:小数点精度
			static WNum^ calcPI2(WNum^ x,WNum^ n,WNum^ eps,int fp);
			//ret:PI,fp:小数点精度//50桁まで
			static WNum^ PI50(int fp);

			//ret:E,n:n個のマクローリン展開,eps:精度,fp:小数点精度
			static WNum^ calcE(WNum^ n,WNum^ eps,int fp);
			//ret:E,fp:小数点精度//50桁まで
			static WNum^ E50(int fp);



			//ret:オイラー定数,n:n個のマクローリン展開,eps:精度,fp:小数点精度
			static WNum^ calcEuler(WNum^ n,WNum^ eps,int fp);
			//ret:オイラー定数,fp:小数点精度//50桁まで
			static WNum^ Euler50(int fp);

			//ret:スターリングの公式,x:x,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi,ne:ne
			static WNum^ calcStirling(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi,WNum^ ne);
			//ret:スターリングの公式,x:x,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi,ne:ne
			static WNum^ calcStirling2(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi,WNum^ ne);



			//ret:二項定理,n:n,k:k
			static WNum^ Binomial(WNum^ n,WNum^ k);




			//ret:ベルヌーイ数,x:x,eps:精度,fp:小数点精度
			static WNum^ Bernoulli(WNum^ x,WNum^ eps,int fp);

			//ret:素数か,x:x	
			static bool isPrime(WNum^ x);
			//ret:素数か,x:x	
			static bool isPrime2(WNum^ x);
			//ret:素数か,x:x	
			static bool isPrime3(WNum^ x);
			//ret:素数か,x:x	
			static bool isPrime4(WNum^ x);
			//ret:素数か,x:x	
			static bool isPrime5(WNum^ x);
			//ret:素数か簡易判別,x:x	
			static bool isPrimeEasy(WNum^ x);
			//ret:素数か,x:x,素因数分解p;p,q;q	
			static bool Decomposition(WNum^ x,WNum^ p,WNum^ q);
			//ret:素数か,x:x,素因数分解p;p,q;q	
			static bool Decomposition2(WNum^ x,WNum^ p,WNum^ q);
			//ret:素数か,x:x,素因数分解p;p,q;q	
			static bool Decomposition3(WNum^ x, WNum^ p, WNum^ q);
			//ret:素数か,x:x,素因数分解p;p,q;q	
			static bool Decomposition4(WNum^ x, WNum^ p, WNum^ q);

			//ret:exp,x:x,n:n個のマクローリン展開,eps:精度,fp:小数点精度
			static WNum^ calcExp(WNum^ x,WNum^ n,WNum^ eps,int fp);
			//ret:exp,x:x,n:n個のマクローリン展開,eps:精度,fp:小数点精度
			static WNum^ calcExp2(WNum^ x,WNum^ n,WNum^ eps,int fp);
			//ret:exp,x:x,n:n個のマクローリン展開,eps:精度,fp:小数点精度
			static WNum^ calcExp3(WNum^ x,WNum^ n,WNum^ eps,int fp);

			//ret:log,x:x,n:n個のマクローリン展開,eps:精度,fp:小数点精度
			static WNum^ calcLog(WNum^ x,WNum^ n,WNum^ eps,int fp);
			//ret:log,x:x,n:n個のマクローリン展開,eps:精度,fp:小数点精度
			static WNum^ calcLog2(WNum^ x,WNum^ n,WNum^ eps,int fp);
			//ret:log,x:x,n:n個のマクローリン展開,eps:精度,fp:小数点精度
			static WNum^ calcLog3(WNum^ x,WNum^ n,WNum^ eps,int fp);
			//ret:logyX,x:x,y:y,n:n個のマクローリン展開,eps:精度,fp:小数点精度
			static WNum^ calcLogBase(WNum^ x,WNum^ y,WNum^ n,WNum^ eps,int fp);
	
			//ret:sin,x:ラジアン,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi
			static WNum^ calcSin(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi);
			//ret:cos,x:ラジアン,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi
			static WNum^ calcCos(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi);
			//ret:tan,x:ラジアン,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi
			static WNum^ calcTan(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi);
			//ret:asin,x:ラジアン,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi
			static WNum^ calcAsin(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi);
			//ret:acos,x:ラジアン,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi
			static WNum^ calcAcos(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi);
			//ret:atan,x:ラジアン,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi
			static WNum^ calcAtan(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi);
			//ret:atan2,x:ラジアン,y:ラジアン,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi
			static WNum^ calcAtan2(WNum^ x,WNum^ y,WNum^ n,WNum^ eps,int fp,WNum^ pi);

			//ret:cosec,x:ラジアン,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi
			static WNum^ calcCsc(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi);
			//ret:sec,x:ラジアン,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi
			static WNum^ calcSec(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi);
			//ret:cot,x:ラジアン,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi
			static WNum^ calcCot(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi);
			//ret:acosec,x:ラジアン,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi
			static WNum^ calcAcsc(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi);
			//ret:asec,x:ラジアン,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi
			static WNum^ calcAsec(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi);
			//ret:acot,x:ラジアン,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi
			static WNum^ calcAcot(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi);

			//ret:sinh,x:ラジアン,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi
			static WNum^ calcSinh(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi);
			//ret:cosh,x:ラジアン,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi
			static WNum^ calcCosh(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi);
			//ret:tanh,x:ラジアン,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi
			static WNum^ calcTanh(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi);
			//ret:asinh,x:ラジアン,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi
			static WNum^ calcAsinh(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi);
			//ret:acosh,x:ラジアン,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi
			static WNum^ calcAcosh(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi);
			//ret:atanh,x:ラジアン,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi
			static WNum^ calcAtanh(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi);

			//ret:cosech,x:ラジアン,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi
			static WNum^ calcCsch(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi);
			//ret:sech,x:ラジアン,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi
			static WNum^ calcSech(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi);
			//ret:coth,x:ラジアン,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi
			static WNum^ calcCoth(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi);
			//ret:acosech,x:ラジアン,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi
			static WNum^ calcAcsch(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi);
			//ret:asech,x:ラジアン,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi
			static WNum^ calcAsech(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi);
			//ret:acoth,x:ラジアン,n:n個のマクローリン展開,eps:精度,fp:小数点精度,pi:pi
			static WNum^ calcAcoth(WNum^ x,WNum^ n,WNum^ eps,int fp,WNum^ pi);




	};
*/




class N6LWNum {

  constructor(a) {

    this.typename = "N6LWNum";
    this.m_n = 0;				//基数
    this.m_f = 0;				//桁
    this.m_s = 1;				//符号
    this.m_p = 0;				//小数点の位置
    this.m_fp = 3;				//小数点精度
    this.m_ef = 0;				//エラーフラグ(bit立て)
						//0x0　　：正常
						//0x1　　：エラー
						//0x100　：虚数解

    this.m_str = "";				//String数値


    this.m_nf = [];				//数値データ
    this.m_xor_nn_str = "";
    this.m_xor_ee_str = "";
    this.m_xor_fp = 3;

    if(a != null){
      if(a.typename != null){
        if(a.typename == "N6LWNum"){
          this.m_n = a.m_n;				//基数
          this.m_f = a.m_f;				//桁
          this.m_s = a.m_s;				//符号
          this.m_p = a.m_p;				//小数点の位置
          this.m_fp = a.m_fp;				//小数点精度
          this.m_ef = a.m_ef;				//エラーフラグ(bit立て)
							//0x0　　：正常
							//0x1　　：エラー
							//0x100　：虚数解

          this.m_str = a.m_str.slice();			//String数値


          this.m_nf = a.m_nf.slice();			//数値データ
          this.m_xor_nn_str = a.m_xor_nn_str.slice();
          this.m_xor_ee_str = a.m_xor_ee_str.slice();
          this.m_xor_fp = a.m_xor_fp;
        }
      }
    }
  }

  //n:基数,str:String数値,fp:少数点精度
  //str format:["+/-"]"X..."[".Y..."]"[#["+/-"]"E..."]"
  //+/-:符号,X...:整数部,.Y...:小数部,E...:指数部
  create(n, str, fp){
    this = new N6LWNum();
    this.m_n = n;
    this.m_fp = fp;
    this.m_str = str.slice;
    this.fromstr();
  }

  //str:String数値
  //str format:["+/-"]"X..."[".Y..."]"[#["+/-"]"E..."]""(Z)"
  //+/-:符号,X...:整数部,.Y...:小数部(これでm_fp決定),E...:指数部,(Z):基数
  create(str){
    this = new N6LWNum();
    var ss;
    var sss;
    var a = str.indexOf("(");
    var b = str.indexOf(")");
    this.m_str = str;
    this.m_str.substring(0,a);
    var d = this.m_str.indexOf("#");
    var ss = this.m_str; 
    if(0 <= d) { ss.substring(0,d); }
    var c = ss.indexOf(".");
    if(c < 0){ c = ss.length - 1; }
    sss = str;
    sss.substring(a+1, b-a-1);
    m_n = parseInt(sss);
    m_fp = ss.length - c - 1;
    this.fromstr();
  }

  err(n){
    this.m_ef = n;
  }

  tostr(){
    var i,j;
    var c;
    if(36 < this.m_n){ this.err(1); return; }
    this.m_str="";
    if(this.m_s < 0) this.m_str += '-';
    for(i = this.m_f - 1, j = 0; j <= i; i--){
      if(this.m_nf[i] < 10) c = String.fromCharCode(this.m_nf[i] + '0'.charCodeAt(0));
      else c = String.fromCharCode(this.m_nf[i] - 10 + 'A'.charCodeAt(0));
      this.m_str += c;
      if(i && i == this.m_p){
        this.m_str += '.';
        j = i - this.m_fp - 1;
        if(j < 0) j = 0;
      }
    }
  }
  fromstr(){
    var a,b,i,j,k,x,y,z=0,s=1;
    var c;
    if(36 < this.m_n){ this.err(1); return; }
    this.m_s = 1;
    b = k = 0;
    if(this.m_str.length == 0){
      this.m_str += "0";
    }
    if(this.m_str[0]=='+'){
      b++;
      this.m_s = 1;
    }
    else if(this.m_str[0] == '-'){
      b++;
      this.m_s = -1;
    }

    this.m_p = 0;
    x = this.m_str.indexOf('#');
    if(0 <= x){
      if(('0'.charCodeAt(0) <= this.m_str.charCodeAt(x + 1))&&(this.m_str.charCodeAt(x + 1) <= '9'.charCodeAt(0))) y = 1;
      if(('a'.charCodeAt(0) <= this.m_str.charCodeAt(x + 1))&&(this.m_str.charCodeAt(x + 1) <= 'z'.charCodeAt(0))) y = 1;
      if(('A'.charCodeAt(0) <= this.m_str.charCodeAt(x + 1))&&(this.m_str.charCodeAt(x + 1) <= 'Z'.charCodeAt(0))) y = 1;
      if(this.m_str[x + 1] == '+') y = 2;
      if(this.m_str[x + 1] == '-') { s=-1; y=2; }
      for(i = x + y; i < this.m_str.length; i++){
        z = z * this.m_n;
        if(('0'.charCodeAt(0) <= this.m_str.charCodeAt(i)) && (this.m_str.charCodeAt(i) <= '9'.charCodeAt(0))) z = z + this.m_str.charCodeAt(i)-'0'.charCodeAt(0);
        else if(('a'.charCodeAt(0) <= this.m_str.charCodeAt(i)) && (this.m_str.charCodeAt(i) <= 'z'.charCodeAt(0))) z = z + this.m_str.charCodeAt(i)-'a'.charCodeAt(0) + 10;
        else if(('A'.charCodeAt(0) <= this.m_str.charCodeAt(i)) && (this.m_str.charCodeAt(i) <= 'Z'.charCodeAt(0))) z = z + this.m_str.charCodeAt(i)-'A'.charCodeAt(0) + 10;
        else break;
      }
    }
    else x = this.m_str.length;
    var zz = 0;

    this.m_str = this.m_str.substring(0,x);
    a = this.m_str.indexOf('.');
    if(0 <= a){
      this.m_p = (this.m_str.length - a - 1);
      k++;
    }

    a = x;
    if(this.m_fp < x - b - k - 1) a = this.m_fp + b + k + 1;
    if(s < 0){ a = x - a; this.m_p += z - a; zz = z; }
    else a = 0;
    this.m_str = this.m_str.substring(0,x);

    this.m_f = x - b - k + z - a;
    this.m_nf.resize(this.m_f);
    for(i = zz, j = x - b + zz, k=0; i < j; i++){
      c = this.m_str[i - zz + b];
      if('0'.charCodeAt(0) <= c.charCodeAt(0) && c.charCodeAt(0) <= '9'.charCodeAt(0)){
        a = parseInt(c.charCodeAt(0) - '0'.charCodeAt(0));
        if(this.m_n <= a){ this.err(1); return; }
        this.m_nf[this.m_f - (i - k) - 1] = a;
      }
      else if('a'.charCodeAt(0) <= c.charCodeAt(0) && c.charCodeAt(0) <= 'z'.charCodeAt(0)){
        a = parseInt(c.charCodeAt(0) - 'a'.charCodeAt(0) + 10);
        if(this.m_n <= a){ this.err(1); return; }
        this.m_nf[this.m_f - (i - k) - 1] = a;
      }
      else if('A'.charCodeAt(0) <= c.charCodeAt(0) && c.charCodeAt(0) <= 'Z'.charCodeAt(0)){
        a = parseInt(c.charCodeAt(0) - 'A'.charCodeAt(0) + 10);
        if(this.m_n <= a){ this.err(1); return; }
        this.m_nf[this.m_f - (i - k) - 1] = a;
      }
      else if(!k && c == '.'){
        j = i + this.m_fp + 1;
        if(x - b + zz < j) j = x - b + zz;
        k++;
      }
      else{ this.err(1); return; }
    }

    for(i = 0, a = 0; i < this.m_p; i++){
      if(!this.m_nf[i]) a++;
      else break;
    }
    this.m_f -= a;
    this.m_p -= a;
    this.m_nf.shift(a);

    this.tostr();
  }

  cardinal(n){
    if(n < 0 || 36 < n) { this.err(1); return; }
    var ret = new N6LWNum(this.m_n,"0",this.m_fp);
    var i,a,b,c,d,e,f,g,h;
    a = 0;
    b = this.m_n;
    c = 1;
    e = 0;
    f = this.m_p;
    g = 0;
    h = 0;
    ret.m_nf = [];
    if(b == n) return new N6LWNum(this);
    for(i = this.m_f - 1; 0 <= i; i--){
      a = a + this.m_nf[i];
      c = a % b;
      d = Math.floor(a / b);
      while(0 < d){
        a = d;
        ret.m_nf.push(c);
        e++;
        c = a % b;
        d = Math.floor(a / b);
      }
    }
    ret.m_f = e;
    ret.tostr();
    return new N6LWNum(ret);
  }

  opr_mns(){
    var mnsone = new N6LWNum(this.m_n, "-1", this.m_fp);
    return new N6LWNum(this.opr_mul(mnsone));
  }
  opr_add(obj){
    var ret = new N6LWNum();
    var tmp1 = new N6LWNum();
    var tmp2 = new N6LWNum();
    var t1 = new N6LWNum(this);
    var a,b,f,g,i,j,m,n,o,p;

    tmp1 = new N6LWNum(obj);
    if(t1.m_n != tmp1.m_n)
    {
      if(t1.m_n < tmp1.m_n){ ret.m_n = tmp1.m_n; }
      else{ ret.m_n = t1.m_n; }
    }
    t1 = t1.cardinal(10);
    tmp1 = tmp1.cardinal(10);
    f = 0;
    g = t1.m_p - tmp1.m_p;
    a = t1.m_f - t1.m_p;
    b = tmp1.m_f - tmp1.m_p;
    if(a < b){ f += b; }
    else{ f += a; }
    a=t1.m_p;
    b=tmp1.m_p;
    if(a < b){
      if(t1.m_fp < b) b = t1.m_fp;
      f += b; ret.m_p = b;
      p=0; o= b - a;
    }
    else{
      if(t1.m_fp < a) a = t1.m_fp;
      f += a; ret.m_p = a;
      o = 0; p = a - b;
    }
    ret.m_f = f + 1;
    ret.m_nf.resize(ret.m_f);
    ret.m_fp = t1.m_fp;
    ret.m_s = 1;
    for(i = b = 0; i < f; i++){
      j = i - o;
      if(0 <=j && j < t1.m_f){
        m = t1.m_nf[j] * t1.m_s;
      }
      else m = 0;
      j = i - p;
      if(0 <= j && j < tmp1.m_f){
        n = tmp1.m_nf[j] * tmp1.m_s;
      }
      else n = 0;
      a = m + n + b;
      if(t1.m_n <= a){ a -= t1.m_n; b = 1; }
      else if(a < -t1.m_n){ a += t1.m_n*2; b=-2; }
      else if(a < 0){ a += t1.m_n; b = -1; }
      else b = 0;
      ret.m_nf[i] = a;
    }
    if(0 < b) ret.m_nf[f] = 1;
    else if(b < -1){
      ret.m_nf[f] = 1;
      ret.m_s = -1;
    }
    else if(b < 0){
      ret.m_nf[f] = 0;
      ret.m_s = -1;
    }
    else ret.m_nf[f] = 0;
    ret.normalization();
    if(ret.m_s < 0){
      tmp2.tmpsub(ret.m_n, ret.m_p, ret.m_fp, ret.m_f + 1);
      ret = tmp2.opr_add(ret);
      ret.m_s = -1;
      ret.tostr();
    }
    return new N6LWNum(ret);
  }
  opr_sub(obj){
    return new N6LWNum(this.opr_add(obj.opr_mns()));
  }
  opr_mul(obj){
    ret = new N6LWNum();
    tmp1 = new N6LWNum();
    t1 = new N6LWNum(this);
    var a,b,c,f,g,i,j,k;

    tmp1 = new N6LWNum(obj);
    if(t1.m_n != tmp1.m_n)
    {
      if(t1.m_n < tmp1.m_n){ t1 = t1.cardinal(tmp1.m_n); }
      else{ tmp1 = tmp1.cardinal(t1.m_n);}
    }
    ret.m_n = t1.m_n;
    f = 0;
    g = t1.m_p - tmp1.m_p;
    a = t1.m_f;
    b = tmp1.m_f;
    f += a + b - 1;
    a = t1.m_p;
    b = tmp1.m_p;
    if(t1.m_fp < a) a = t1.m_fp;
    if(t1.m_fp < b) b = t1.m_fp;
    ret.m_p = a + b;
    ret.m_f = f + 1;
    ret.m_nf.resize(ret.m_f);
    ret.m_fp = t1.m_fp;
    ret.m_s = 1;
    for(a = b = i = 0; i < f; i++){
      k = i + 1;
      a = b;
      c = 0;
      if(t1.m_f < tmp1.m_f){
        if(t1.m_f < k){
          if(tmp1.m_f < k){ k = tmp1.m_f + t1.m_f - k; c = t1.m_f - k; }
          else k = t1.m_f;
        }
      }
      else{
        if(tmp1.m_f < k){
          if(t1.m_f < k){ k = t1.m_f + tmp1.m_f - k; c = tmp1.m_f - k; }
          else k = tmp1.m_f;
        }
      }
      for(j = 0; j < k; j++){
        if(t1.m_f < tmp1.m_f){
          a += t1.m_nf[j + c] * tmp1.m_nf[i - (j + c)];
        }
        else{
          a += t1.m_nf[i - (j + c)] * tmp1.m_nf[j + c];
        }
      }
      b = a / t1.m_n;
      a = a % t1.m_n;
      ret.m_nf[i] = a;
    }
    ret.m_nf[f] = b;
    if((t1.m_s < 0 && 0 < tmp1.m_s) || (0 < t1.m_s && tmp1.m_s < 0)) ret.m_s = -1;
      ret.normalization();
      return new N&LWNum(ret);
  }

  opr_div(obj, mod){
    ss = "";
    ret = new N6LWNum();
    tmp1 = new N6LWNum();
    tmp2 = new N6LWNum();
    tmp3 = new N6LWNum();
    tmp4 = new N6LWNum();
    t1 = new N6LWNum(this);
    var a,b,c,d,e,f,g,i,j,k=0;

    zero = new N6LWNum(obj.m_n,"0",obj.m_fp);
//############################
    if(obj == zero)
    {
      return err(1);
    }

    tmp1 = new N6LWNum(obj);
    if(t1.m_n != tmp1.m_n)
    {
      if(t1.m_n < tmp1.m_n){ t1 = t1.cardinal(tmp1.m_n); }
      else{ tmp1 = tmp1.cardinal(this.m_n);}
    }
    tmp2 = new N6LWNum(t1);
    zero = new N6LWNum(tmp2.m_n,"0",tmp2.m_fp);
    one = new N6LWNum(tmp2.m_n,"1",tmp2.m_fp);
    mns = new N6LWNum(tmp2.m_n,"-1",tmp2.m_fp);

//############################
    if(tmp1 < zero)
    {
      tmp1 = tmp1.opr_mul(mns);
      tmp2 = tmp2.opr_mul(mns);
    }

    ret.m_n = tmp2.m_n;
    f = 0;
    g = tmp2.m_p - tmp1.m_p;
    if(tmp1.m_p <= tmp2.m_p) tmp2.m_p = tmp2.m_p - tmp1.m_p;
    else{
      a = tmp1.m_p - tmp2.m_p;
      for(i = 0; i < a; i++) tmp2.m_nf.unshift(0);
      tmp2.m_f += a;
      tmp2.m_p = 0;
    }
    tmp1.m_p=0;
    if(tmp2.m_fp < tmp2.m_p) tmp2.m_p = tmp2.m_fp;
    tmp1.normalization();
    tmp2.normalization();
    d = e = 0;

    a = tmp2.m_f;
    b = tmp1.m_f;
//############################
    if(tmp1.abs() <= tmp2.abs()){
      if(a < b) f = tmp1.m_f - tmp2.m_f + 1 + tmp2.m_fp;
      else f = tmp2.m_f - tmp1.m_f + 1 + tmp2.m_fp;
    }
    else{
      if(a < b) f = tmp1.m_f - tmp2.m_f + 1 + tmp2.m_fp;
      else f = tmp2.m_f - tmp1.m_f + 1 + tmp2.m_fp;
    }
    e=1;
    c=f;

    ret.m_f = f;
    ret.m_nf.resize(ret->m_f);
    ret.m_fp = tmp2.m_fp;
    ret.m_s = 1;
		
    if(0 <= ((tmp2.m_f - tmp2.m_p) - (tmp1.m_f - tmp1.m_p))) ret.m_p = f -((tmp2.m_f - tmp2.m_p) - (tmp1.m_f - tmp1.m_p)) - 1;
    else ret.m_p = f - 1;

    tmp4 = new N6LWNum(tmp2.m_n,"0",tmp2.m_fp);
    for(i=0; i < tmp1.m_f; i++){
//############################
      if(tmp4.abs() < tmp2.abs()){
        ss = tmp2.m_n.toString();
        tmp3 = new N6LWNum(tmp2.m_n,ss,tmp2.m_fp);
        tmp4 = tmp4.opr_mul(tmp3);
        ss = tmp2.m_nf[tmp2.m_f - i - e].toStoring());
        tmp3 = new N6LWNum(tmp2.m_n,ss,tmp2.m_fp);
        tmp4 = tmp4.opr_add(tmp3);
        d++;
        if(tmp2.m_f - tmp2.m_p <= i) k++;
      }
    }
    for(a = i = 0;i < f - k; i++){
      for(j = tmp2.m_n -1; 0 < j; j--){
        ss = j.toString();
        tmp3 = new N6LWNum(tmp2.m_n,ss,tmp2.m_fp);
        tmp3 = tmp1.opr_mul(tmp3);
//############################
        if(tmp3.abs()<=tmp4.abs()){
          ret.m_nf[ret.m_f - i - e - k] = j;
          tmp4 = tmp4.opr_sub(tmp3);
          break;
        }
      }
      if(i == f - 1) break;
      ss = tmp2.m_n.toString();
      tmp3 = new N6LWNum(tmp2.m_n,ss,tmp2.m_fp);
      tmp4 = tmp4.opr_mul(tmp3);
      if((i < c) && (0 <= tmp2.m_f - i - e - d)){
        ss = tmp2.m_nf[tmp2.m_f - i - e - d].toString();
        tmp3 = new N6LWNum(tmp2.m_n,ss,tmp2.m_fp);
        tmp4 = tmp4.opr_add(tmp3);
      }
      else {
        tmp3 = new N6LWNum(tmp2.m_n,"0",tmp2.m_fp);
//############################
        if(tmp4.abs() == tmp3abs()) break;
      }
    }

    if((tmp2.m_s < 0 && 0 < tmp1.m_s) || (0 < tmp2.m_s && tmp1.m_s<0)) ret.m_s=-1;

    ret.normalization();

    var wni = new N6LNum(ret.getInteger());
    tmp3 = obj.opr_mul(wni);
    tmp3 = tmp3.abs();
//############################
    if(zero < this) mod.opr_eql(this.opr_sub(mp3));
    else mod.opr_eql(this.opr_add(tmp3));

    return new N6LWNum(ret);
  }

  power(n){
    var aa = this.cardinal(10);
    var nn = n.cardinal(10);
    var b = new N6LWNum(aa);
    var zero = new N6LWNum(10,"0",aa.m_fp);
    var one = new N6LWNum(10,"1",aa.m_fp);
    var two = new N6LWNum(10,"2",aa.m_fp);
    var r = new N6LWNum(10,"1",aa.m_fp);
    var abs_n = new N6LWNum();
//############################
    if(nn < zero) abs_n =-nn;
    else abs_n = nn;
    var c = new N6LWNum();
    var mod  = [new N6LWNum()];

     abs_n.m_fp = 0;
	
//############################
    while(abs_n > zero){
      abs_n = abs_n.opr_div(two, mod);
      c.opr_eql(mod[0]);
//############################
      if(c == one){
        r = r.opr_mul(b);
      }
      b = b.opr_mul(b);
    }

    var ret = new N6LWNum();
//############################
    if(nn >= zero) ret = new N6LWNum(r);
    else if(r > zero) ret = one.opr_div(r, mod);
    else ret = zero;
    return new N6LWNum(ret.cardinal(aa.m_n));
  }
  nthroot(n){
    var aa = this.cardinal(10);
    var nn = n.cardinal(10);
    var nnn;
//############################
    if(a.m_n < n.m_n) nnn = n.m_n;
    else nnn = this.m_n;
    var x = new N6LWNum();
    var y = new N6LWNum();
    var zero = new N6LWNum(10,"0",this.m_fp);
    var one = new N6LWNum(10,"1",this.m_fp);

//############################
    if(aa <= zero || nn < zero) { return err(1); }
    if(nn == zero) { return new N6LWNum(one.cardinal(nnn)); }

    var b = this.cardinal(10);
    var c = nn - one;
    var d = new N6LWNum();
    var e = new N6LWNum();
    var f = new N6LWNum();
    var mod = [new N6LWNum()];

//############################
    y = ((b > one) ? b : one);
    do{
      x = y;
      d = c.opr_mul(x);
      if(x == zero) break;
      f = x.power(c);
      if(f == zero) break;
      e = b.opr_div(f,mod);
      y = d.opr_add(e).opr_div(nn,mod);
//if((y.m_nf[0]!=0)&&(y.m_fp<y.m_f))break;
    }while(y < x);

    return new N6LWNum(y.cardinal(nnn));
  }


  xs210(str){
    return parseInt(str);
  }
  x102s(n){
    return n.toString();
  }
  xn210(str, n){
    var ret = "";
    var i,a;
    for(i = 0, a = 0; i < str.length - 1; i++){
      a = (a + this.char2int(str[i])) * n;
    }
    a += this.char2int(str[i]);
    ret = this.x102s(a);
    return ret;
  }
  x102n(str, n){
    var ret = "";
    var tmp = "";
    var c;
    var i,a;
    a = this.xs210(str);
//############################
    for(i = a; i != 0; i /= n){
      c = this.int2char(i % n);
      tmp += c;
    }
    for(i = tmp.Length - 1; 0 <= i; i--){
      ret += tmp[i];
    }
    return ret;
  }
//############################
  compFP(){
    var tmp1 = new N6LWNum();
    var tmp2 = new N6LWNum();
    var tmp3 = new N6LWNum();
    var i;
    tmp1 = new N6LWNum(10,"1",this.m_fp);
    tmp2 = new N6LWNum(10,"1",this.m_fp);
    var cd = new N6LWNum(10,this.x102s(this.m_n),this.m_fp);
    for(i = 0; i <= this.m_p; i++){
      tmp1 = tmp1.opr_mul(cd);
    }
    var mod = [new N6LWNum()];
    tmp3 = tmp2.opr_div(tmp1,mod);
    return tmp3->m_fp;
  }

  xn210(obj, n){
    var ret = new N6LWNum();
    var tmp1 = new N6LWNum();
    var tmp2 = new N6LWNum();
    var tmp3 = new N6LWNum();
    var tmps1 = "";
    var wt;
    var i,j=0,k;
    j = obj.m_fp;
    //j=obj->compFP();
    tmp1 = new N6LWNum(10,"0",j);
    tmp3 = new N6LWNum(10,"1",j);
    var cd = new N6LWNum(10,this.x102s(n),j);
    for(i = 0; i < obj.m_p; i++){
      tmp3 = tmp3.opr_mul(cd);
    }
    for(i = 0; i < obj.m_str.length - 1; i++){
      if((('0'.charCodeAt(0) <= obj.m_str.charCodeAt(i)) && (obj.m_str.charCodeAt(i) <= '9'.charCodeAt(0)))||
         (('A'.charCodeAt(0) <= obj.m_str.charCodeAt(i)) && (obj.m_str.charCodeAt(i) <= 'Z'.charCodeAt(0)))||
         (('a'.charCodeAt(0) <= obj.m_str.charCodeAt(i)) && (obj.m_str.charCodeAt(i) <= 'z'))){
        tmps1 = "";
        wt = obj.m_str[i];
        k=0;
        if(('0' <= wt) && (wt <= '9')) k = wt.charCodeAt(0);
        else if(('A'.charCodeAt(0) <= wt.charCodeAt(0)) && (wt.charCodeAt(0) <= 'Z'.charCodeAt(0))) k = parseInt(wt.charCodeAt(0) - 'A'.charCodeAt(0)) + 10;
        else if(('a'.charCodeAt(0) <= wt.charCodeAt(0)) && (wt.charCodeAt(0) <= 'z'.charCodeAt(0))) k = parseInt(wt.charCodeAt(0) - 'a'.charCodeAt(0)) + 10;
        tmps1 += k.toString();
        tmp2 = new N6LWNum(10,tmps1,j);
        tmp1 = tmp1.opr_add(tmp2).opr_mul(cd);
      }
    }
    tmps1 = "";
    wt = obj.m_str[i];
    k = 0;
    if(('0'.charCodeAt(0) <= wt.charCodeAt(0)) && (wt.charCodeAt(0) <= '9'.charCodeAt(0))) k = wt.charCodeAt(0);
    else if(('A'.charCodeAt(0) <= wt.charCodeAt(0)) && (wt.charCodeAt(0) <= 'Z'.charCodeAt(0))) k = parseInt(wt.charCodeAt(0) - 'A'.charCodeAt(0)) + 10;
    else if(('a'.charCodeAt(0) <= wt.charCodeAt(0)) && (wt.charCodeAt(0) <= 'z'.charCodeAt(0))) k = parseInt(wt.charCodeAt(0) - 'a'.charCodeAt(0)) + 10;
    tmps1 += k.toString();
    tmp2 = new N6LWNum(10,tmps1,j);
    var mod = [new N6LWNum()];
    ret = tmp1.opr_add(tmp2).opr_div(tmp3,mod);

    ret.m_s = obj.m_s;
    ret.normalization();

    return new N6LWNum(ret);
  }
  x102n(obj, n){
    var ret = new N6LWNum();
    var tmp1 = new N6LWNum();
    var wni = new N6LWNum();
    var wnd = new N6LWNum();
//############################
    wni = abs(getInteger(obj));
    wnd = abs(getDecimal(obj));
    var tmps1 = "";
    var tmps2= "";
    var c;
    var i,j;
    j = obj.m_fp;
//j=obj->compFP();
    var zero = new N6LWNum(10,"0",0);
    var one = new N6LWNum(10,"1",0);
    var cd = new N6LWNum(10,obj.x102s(n),0);
    var mod = [new N6LWNum()];
    var mm = new N6LWNum();

    //整数部
    tmp1 = new N6LWNum(10,wni.m_str,0);
    if(tmp1 != zero){
      for(; one <= tmp1; tmp1 = tmp1.opr_div(cd,mod)){
        tmp1.opr_div(cd,mod);
        mm.opr_eql(mod);
        c = wnum2char(mm);
        tmps1 += c;
      }
      for(i = tmps1.Length - 1; 0 <= i; i--){
        tmps2 += tmps1[i];	
      }
      ret = new N6LWNum(n,tmps2,j);
      ret.normalization();
    }
    else{
      ret = new N6LWNum(n,"0",j);
    }
    //小数部
    tmps1 = "0.";
    tmps2 = "";
    tmp1 = new N6LWNum(10,wnd->m_str,j);
    cd = new N6LWNum(10,obj.x102s(n),j);
    zero = new N6LWNum(10,"0",j);
    one = new WNum(10,"1",j);
    if(tmp1 != zero){
      for(i = 0; ((i < j) && (tmp1 != zero) && (tmp1 != one)); i++){
        tmp1 = tmp1.opr_mul(cd);
        c = wnum2char(getInteger(tmp1));
        tmps1 += c;
        tmp1 = getDecimal(tmp1);
      }
      tmp1 = new WNum(n,tmps1,j);
      ret = ret.opr_add(tmp1);
      ret.normalization();
    }
	
    ret.m_s = obj.m_s;
    ret.normalization();

    return new N6LWNum(ret);
  }
  wnum2char(a){
    var i = this.wnum2int(a);
    return this.int2char(i);
  }
  wnum2int(a){
    return this.xs210(this.xn210(a.m_str,a.m_n));
  }
  int2char(int a){
    if(a < 10) return String.fromCharCode(a + '0'.charCodeAt(0));
    else if(a < 36) return String.fromCharCode(a - 10 + 'A'.charCodeAt(0));
    return 0;
  }
  char2int(c){
    if('0'.charCodeAt(0) <= c.charCodeAt(0) && c.charCodeAt(0) <= '9'.charCodeAt(0)){ return parseInt(c.charCodeAt(0) - '0'.charCodeAt(0)); }
    else if('a'.charCodeAt(0) <= c.charCodeAt(0) && c.charCodeAt(0) <= 'z'.charCodeAt(0)){ return parseInt(c.charCodeAt(0) - 'a'.charCodeAt(0)+10); }
    else if('A'.charCodeAt(0) <= c.charCodeAt(0) && c.charCodeAt(0) <= 'Z'.charCodeAt(0)){ return parseInt(c.charCodeAt(0) - 'A'.charCodeAt(0)+10); }
    return 0;
  }

  tostr(){
    var i,j;
    var c;
    if(36 < this.m_n){ this.err(1); return; }
    this.m_str="";
    if(this.m_s < 0) this.m_str += '-';
    for(i = this.m_f-1, j=0; j <= i; i--){
      if(this.m_nf[i] < 10) c = String.fromCharCode(this.m_nf[i] + '0'.charCodeAt(0));
      else c = String.fromCharCode(this.m_nf[i] - 10 + 'A'.charCodeAt(0));
      this.m_str += c;
      if(i && i == this.m_p){
        this.m_str += '.';
        j = i - this.m_fp - 1;
        if(j < 0) j = 0;
      }
    }
  }
  fromstr(){
    var a,b,i,j,k,x,y,z=0,s=1;
    var c;
    if(36 < this.m_n){ this.err(1); return; }
    this.m_s = 1;
    b = k = 0;
    if(this.m_str.length == 0){
      this.m_str += "0";
    }
    if(this.m_str[0]=='+'){
      b++;
      this.m_s = 1;
    }
    else if(this.m_str[0] == '-'){
      b++;
      this.m_s = -1;
    }

    this.m_p = 0;
    x = this.m_str.indexOf('#');
    if(0 <= x){
      if(('0'.charCodeAt(0) <= this.m_str.charCodeAt(x + 1))&&(this.m_str.charCodeAt(x + 1) <= '9'.charCodeAt(0))) y = 1;
      if(('a'.charCodeAt(0) <= this.m_str.charCodeAt(x + 1))&&(this.m_str.charCodeAt(x + 1) <= 'z'.charCodeAt(0))) y = 1;
      if(('A'.charCodeAt(0) <= this.m_str.charCodeAt(x + 1))&&(this.m_str.charCodeAt(x + 1) <= 'Z'.charCodeAt(0))) y = 1;
      if(this.m_str[x + 1] == '+') y = 2;
      if(this.m_str[x + 1] == '-') { s=-1; y=2; }
      for(i = x + y; i < this.m_str.length; i++){
        z = z * this.m_n;
        if(('0'.charCodeAt(0) <= this.m_str.charCodeAt(i)) && (this.m_str.charCodeAt(i) <= '9'.charCodeAt(0))) z = z + this.m_str.charCodeAt(i)-'0'.charCodeAt(0);
        else if(('a'.charCodeAt(0) <= this.m_str.charCodeAt(i)) && (this.m_str.charCodeAt(i) <= 'z'.charCodeAt(0))) z = z + this.m_str.charCodeAt(i)-'a'.charCodeAt(0) + 10;
        else if(('A'.charCodeAt(0) <= this.m_str.charCodeAt(i)) && (this.m_str.charCodeAt(i) <= 'Z'.charCodeAt(0))) z = z + this.m_str.charCodeAt(i)-'A'.charCodeAt(0) + 10;
        else break;
      }
    }
    else x = this.m_str.length;
    var zz = 0;

    this.m_str = this.m_str.substring(0,x);
    a = this.m_str.indexOf('.');
    if(0 <= a){
      this.m_p = (this.m_str.length - a - 1);
      k++;
    }

    a = x;
    if(this.m_fp < x - b - k - 1) a = this.m_fp + b + k + 1;
    if(s < 0){ a = x - a; this.m_p += z - a; zz = z; }
    else a = 0;
    this.m_str = this.m_str.substring(0,x);

    this.m_f = x - b - k + z - a;
    this.m_nf.resize(this.m_f);
    for(i = zz, j = x - b + zz, k=0; i < j; i++){
      c = this.m_str[i - zz + b];
      if('0'.charCodeAt(0) <= c.charCodeAt(0) && c.charCodeAt(0) <= '9'.charCodeAt(0)){
        a = parseInt(c.charCodeAt(0) - '0'.charCodeAt(0));
        if(this.m_n <= a){ this.err(1); return; }
        this.m_nf[this.m_f - (i - k) - 1] = a;
      }
      else if('a'.charCodeAt(0) <= c.charCodeAt(0) && c.charCodeAt(0) <= 'z'.charCodeAt(0)){
        a = parseInt(c.charCodeAt(0) - 'a'.charCodeAt(0) + 10);
        if(this.m_n <= a){ this.err(1); return; }
        this.m_nf[this.m_f - (i - k) - 1] = a;
      }
      else if('A'.charCodeAt(0) <= c.charCodeAt(0) && c.charCodeAt(0) <= 'Z'.charCodeAt(0)){
        a = parseInt(c.charCodeAt(0) - 'A'.charCodeAt(0) + 10);
        if(this.m_n <= a){ this.err(1); return; }
        this.m_nf[this.m_f - (i - k) - 1] = a;
      }
      else if(!k && c == '.'){
        j = i + this.m_fp + 1;
        if(x - b + zz < j) j = x - b + zz;
        k++;
      }
      else{ this.err(1); return; }
    }

    for(i = 0, a = 0; i < this.m_p; i++){
      if(!this.m_nf[i]) a++;
      else break;
    }
    this.m_f -= a;
    this.m_p -= a;
    this.m_nf.shift(a);

    this.tostr();
  }
  tmpsub(int n,int p,int fp,int f){
    this.m_n = n;
    this.m_p = p;
    this.m_fp = fp;
    this.m_f = f;
    this.m_nf.resize(this.m_f);
    this.m_nf[this.m_f - 1] = 1;
    this.tostr();
    return this;
  }
/*

	WNum WNum::operator=(WNum obj){
		m_n=obj.m_n;
		m_f=obj.m_f;
		m_s=obj.m_s;
		m_p=obj.m_p;
		m_fp=obj.m_fp;
		m_ef=obj.m_ef;
		m_nf=(vector<int>^)obj.m_nf->Clone(); 
		m_str=(String^)obj.m_str->Clone();
		WNum ret;
		ret.m_n=obj.m_n;
		ret.m_f=obj.m_f;
		ret.m_s=obj.m_s;
		ret.m_p=obj.m_p;
		ret.m_fp=obj.m_fp;
		ret.m_ef=obj.m_ef;
		ret.m_nf=(vector<int>^)obj.m_nf->Clone(); 
		ret.m_str=(String^)obj.m_str->Clone();
		return ret;
	}
	WNum^ WNum::operator=(WNum^ obj){
		m_n=obj->m_n;
		m_f=obj->m_f;
		m_s=obj->m_s;
		m_p=obj->m_p;
		m_fp=obj->m_fp;
		m_ef=obj->m_ef;
		m_nf=(vector<int>^)obj->m_nf->Clone(); 
		m_str=(String^)obj->m_str->Clone();
		WNum^ ret=gcnew WNum();
		ret->m_n=obj->m_n;
		ret->m_f=obj->m_f;
		ret->m_s=obj->m_s;
		ret->m_p=obj->m_p;
		ret->m_fp=obj->m_fp;
		ret->m_ef=obj->m_ef;
		ret->m_nf=(vector<int>^)obj->m_nf->Clone(); 
		ret->m_str=(String^)obj->m_str->Clone();
		return ret;
	}
*/

  opr_eql(obj){
    if(obj != null){
      if(obj.typename != null){
        if(obj.typename == "N6LWNum"){
          this.m_n = obj.m_n;
          this.m_f = obj.m_f;
          this.m_s = obj.m_s;
          this.m_p = obj.m_p;
          this.m_fp = obj.m_fp;
          this.m_ef = obj.m_ef;
          this.m_nf = obj.m_nf.slice(); 
          this.m_str = obj.m_str.slice();
        }
      }
    }
    return this;
  }


}

