﻿var chk = false;
var TMan = new N6LTimerMan(); // タイマーマネージャーのインスタンス
var x3domRuntime; // X3DOMランタイムオブジェクトを保持する変数

var fr = 1000; // 浮動小数点数を丸めるための係数 (1000で小数点以下3桁まで表示)
var A = new N6LMatrix(4).UnitMat(); // 空間1: 現在のビュー変換行列（回転と移動を含む）。4x4の単位行列で初期化。
var A2 = new N6LMatrix(4).UnitMat(); // 空間2: ユーザーが適用する追加の変換行列。4x4の単位行列で初期化。

/**
 * ApplyXXXボタンが押されたときにビューと空間1などを復元するために呼び出される関数
 * 回転ベクトル (Axis-Angle) と移動量 (Translation) の入力が変更されたときに呼び出される関数。
 * 入力された値を元に空間1の変換行列を更新し、他の形式の変換情報も更新します。
 */
function chgrotVec(){
  // 'rotin'要素から入力された回転ベクトル文字列を取得し、'rot'要素に設定
  var elm = document.getElementById('rotin');
  var ro = String(elm.value);
  elm = document.getElementById('rot');
  elm.value = ro;

  // 'trnsin'要素から入力された移動量文字列を取得し、'trns'要素に設定
  elm = document.getElementById('trnsin');
  var tr = String(elm.value);
  elm = document.getElementById('trns');
  elm.value = tr;

  // 各文字列からN6LVectorオブジェクトをパース
  var rot = new N6LVector().Parse(ro); // 回転ベクトル (軸と角度)
  var trs = new N6LVector().Parse(tr); // 移動ベクトル (X, Y, Z)

  var radioList = document.getElementsByName("INV"); // 'INV'という名前のラジオボタンリストを取得 (逆行列モード用)
  var dt = []; // 逆行列計算時に使用される可能性のある一時変数

  // ラジオボタンの選択状態に基づいて行列Aを設定
  if(radioList[0].checked) { // 最初のラジオボタンがチェックされている場合（逆行列モード）
    A = rot.Matrix().TranslatedMat(trs); // 回転ベクトルから回転行列を生成し、移動行列を適用
    A = A.InverseMat(dt); // 生成した行列の逆行列を計算
  } else { // それ以外の場合（通常モード）
    A = rot.Matrix().TranslatedMat(trs); // 回転ベクトルから回転行列を生成し、移動行列を適用
  }

  // 更新された行列Aから回転ベクトルを再計算し、X3DOMビューアに反映
  rot = A.Vector();
  elm = document.getElementById('viewp001');
  elm.setAttribute('orientation', rot.ToX3DOM().toString());

  // 行列Aからオイラー角を計算し、'rotEA'要素に設定
  var ea = A.EulerAngle(1,2,3); // (1,2,3)は回転軸の順序 (例: XYZ)
  elm = document.getElementById('rotEA');
  var str = String(Math.floor(ea.x[1]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[2]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[3]*(180.0/Math.PI)*fr)/fr);
  elm.value = str;

  // 行列Aからクォータニオンを計算し、'rotQT'要素に設定
  var qt = A.Quaternion();
  elm = document.getElementById('rotQT');
  str = 'true,4,'+String(Math.floor(qt.q.x[0]*fr)/fr)+','+String(Math.floor(qt.q.x[1]*fr)/fr)+','+String(Math.floor(qt.q.x[2]*fr)/fr)+','+String(Math.floor(qt.q.x[3]*fr)/fr);
  elm.value = str;

  // 'rotOC'要素に位置・姿勢結合ベクトルを設定（trsとqtを結合）
  // WXYZ (trs) + WXYZ (qt) の8成分形式
  elm = document.getElementById('rotOC');
  str = 'true,8,'+String(Math.floor(trs.x[0]*fr)/fr)+','+String(Math.floor(trs.x[1]*fr)/fr)+','+String(Math.floor(trs.x[2]*fr)/fr)+','+String(Math.floor(trs.x[3]*fr)/fr);
  str += ','+String(Math.floor(qt.q.x[0]*fr)/fr)+','+String(Math.floor(qt.q.x[1]*fr)/fr)+','+String(Math.floor(qt.q.x[2]*fr)/fr)+','+String(Math.floor(qt.q.x[3]*fr)/fr);
  elm.value = str;

  // 'rotMT'要素に現在の変換行列Aの成分を設定
  elm = document.getElementById('rotMT');
  str = 'true,4&#13;true,4,'+String(Math.floor(A.x[0].x[0]*fr)/fr)+','+String(Math.floor(A.x[0].x[1]*fr)/fr)+','+String(Math.floor(A.x[0].x[2]*fr)/fr)+','+String(Math.floor(A.x[0].x[3]*fr)/fr) +
        '&#13;true,4,'+String(Math.floor(A.x[1].x[0]*fr)/fr)+','+String(Math.floor(A.x[1].x[1]*fr)/fr)+','+String(Math.floor(A.x[1].x[2]*fr)/fr)+','+String(Math.floor(A.x[1].x[3]*fr)/fr) +
        '&#13;true,4,'+String(Math.floor(A.x[2].x[0]*fr)/fr)+','+String(Math.floor(A.x[2].x[1]*fr)/fr)+','+String(Math.floor(A.x[2].x[2]*fr)/fr)+','+String(Math.floor(A.x[2].x[3]*fr)/fr) +
        '&#13;true,4,'+String(Math.floor(A.x[3].x[0]*fr)/fr)+','+String(Math.floor(A.x[3].x[1]*fr)/fr)+','+String(Math.floor(A.x[3].x[2]*fr)/fr)+','+String(Math.floor(A.x[3].x[3]*fr)/fr);
  elm.value = str;

  // 逆行列モードの場合、内部状態の行列Aを再度逆行列に戻す（表示用に一時的に逆行列にしたため）
  if(radioList[0].checked) {
    A = A.InverseMat(dt);
  }
}

/**
 * ApplyXXXボタンが押されたときにビューと空間1などを復元するために呼び出される関数
 * オイラー角と移動量の入力が変更されたときに呼び出される関数。
 * 入力された値を元に空間1の変換行列を更新し、他の形式の変換情報も更新します。
 */
function chgrotEA(){
  // 'rotEAin'要素から入力されたオイラー角文字列を取得し、'rotEA'要素に設定
  var elm = document.getElementById('rotEAin');
  var roEA = String(elm.value);
  elm = document.getElementById('rotEA');
  elm.value = roEA;

  // 'trnsin'要素から入力された移動量文字列を取得し、'trns'要素に設定
  elm = document.getElementById('trnsin');
  var tr = String(elm.value);
  elm = document.getElementById('trns');
  elm.value = tr;
  var trs = new N6LVector().Parse(tr); // 移動ベクトルをパース

  // オイラー角文字列をパースし、ラジアンに変換してN6LVectorオブジェクトを生成
  var tk = roEA.split(',');
  var ea = new N6LVector([1,Number(tk[0])*(Math.PI/180.0),Number(tk[1])*(Math.PI/180.0),Number(tk[2])*(Math.PI/180.0)],true);

  // 単位行列から開始し、各軸周りにオイラー角で回転を適用して回転行列を構築
  var ax = new N6LVector(4,true).UnitVec(1); // X軸
  var ay = new N6LVector(4,true).UnitVec(2); // Y軸
  var az = new N6LVector(4,true).UnitVec(3); // Z軸
  A = A.UnitMat().RotAxis(ax,ea.x[1]); // X軸周りの回転
  ay = A.GetRow(2); // 回転後のY軸ベクトルを取得
  A = A.RotAxis(ay,ea.x[2]); // 新しいY軸周りの回転
  az = A.GetRow(3); // 回転後のZ軸ベクトルを取得
  A = A.RotAxis(az,ea.x[3]); // 新しいZ軸周りの回転

  var radioList = document.getElementsByName("INV"); // 'INV'ラジオボタンリストを取得
  var rot = A.Vector(); // 現在の回転行列から回転ベクトルを計算
  var dt = []; // 一時変数

  // ラジオボタンの選択状態に基づいて行列Aを設定（回転と移動を適用）
  if(radioList[0].checked) {
    A = rot.Matrix().TranslatedMat(trs);
    A = A.InverseMat(dt);
  } else {
    A = rot.Matrix().TranslatedMat(trs);
  }

  // 更新された行列Aから回転ベクトルを再計算し、X3DOMビューアに反映
  rot = A.Vector();
  elm = document.getElementById('viewp001');
  elm.setAttribute('orientation', rot.ToX3DOM().toString());

  // 各表示フィールドを更新
  elm = document.getElementById('rot');
  var str = 'true,4,'+String(Math.floor(rot.x[0]*fr)/fr)+','+String(Math.floor(rot.x[1]*fr)/fr)+','+String(Math.floor(rot.x[2]*fr)/fr)+','+String(Math.floor(rot.x[3]*fr)/fr);
  elm.value = str;

  var qt = A.Quaternion();
  elm = document.getElementById('rotQT');
  str = 'true,4,'+String(Math.floor(qt.q.x[0]*fr)/fr)+','+String(Math.floor(qt.q.x[1]*fr)/fr)+','+String(Math.floor(qt.q.x[2]*fr)/fr)+','+String(Math.floor(qt.q.x[3]*fr)/fr);
  elm.value = str;

  elm = document.getElementById('rotOC');
  str = 'true,8,'+String(Math.floor(trs.x[0]*fr)/fr)+','+String(Math.floor(trs.x[1]*fr)/fr)+','+String(Math.floor(trs.x[2]*fr)/fr)+','+String(Math.floor(trs.x[3]*fr)/fr);
  str += ','+String(Math.floor(qt.q.x[0]*fr)/fr)+','+String(Math.floor(qt.q.x[1]*fr)/fr)+','+String(Math.floor(qt.q.x[2]*fr)/fr)+','+String(Math.floor(qt.q.x[3]*fr)/fr);
  elm.value = str;

  elm = document.getElementById('rotMT');
  str = 'true,4&#13;true,4,'+String(Math.floor(A.x[0].x[0]*fr)/fr)+','+String(Math.floor(A.x[0].x[1]*fr)/fr)+','+String(Math.floor(A.x[0].x[2]*fr)/fr)+','+String(Math.floor(A.x[0].x[3]*fr)/fr) +
        '&#13;true,4,'+String(Math.floor(A.x[1].x[0]*fr)/fr)+','+String(Math.floor(A.x[1].x[1]*fr)/fr)+','+String(Math.floor(A.x[1].x[2]*fr)/fr)+','+String(Math.floor(A.x[1].x[3]*fr)/fr) +
        '&#13;true,4,'+String(Math.floor(A.x[2].x[0]*fr)/fr)+','+String(Math.floor(A.x[2].x[1]*fr)/fr)+','+String(Math.floor(A.x[2].x[2]*fr)/fr)+','+String(Math.floor(A.x[2].x[3]*fr)/fr) +
        '&#13;true,4,'+String(Math.floor(A.x[3].x[0]*fr)/fr)+','+String(Math.floor(A.x[3].x[1]*fr)/fr)+','+String(Math.floor(A.x[3].x[2]*fr)/fr)+','+String(Math.floor(A.x[3].x[3]*fr)/fr);
  elm.value = str;

  // 逆行列モードの場合、内部状態の行列Aを再度逆行列に戻す
  if(radioList[0].checked) {
    A = A.InverseMat(dt);
  }
}

/**
 * ApplyXXXボタンが押されたときにビューと空間1などを復元するために呼び出される関数
 * クォータニオンと移動量の入力が変更されたときに呼び出される関数。
 * 入力された値を元に空間1の変換行列を更新し、他の形式の変換情報も更新します。
 */
function chgrotQT(){
  // 'rotQTin'要素から入力されたクォータニオン文字列を取得し、'rotQT'要素に設定
  var elm = document.getElementById('rotQTin');
  var ro = String(elm.value);
  elm = document.getElementById('rotQT');
  elm.value = ro;

  // 'trnsin'要素から入力された移動量文字列を取得し、'trns'要素に設定
  elm = document.getElementById('trnsin');
  var tr = String(elm.value);
  elm = document.getElementById('trns');
  elm.value = tr;
  var trs = new N6LVector().Parse(tr); // 移動ベクトルをパース

  // クォータニオン文字列をパース
  var qt = new N6LQuaternion().Parse(ro);
  var dt = []; // 一時変数

  A = qt.Matrix(); // クォータニオンから回転行列を生成
  var rot = A.Vector(); // 回転ベクトルを計算

  var radioList = document.getElementsByName("INV"); // 'INV'ラジオボタンリストを取得
  // ラジオボタンの選択状態に基づいて行列Aを設定（回転と移動を適用）
  if(radioList[0].checked) {
    A = rot.Matrix().TranslatedMat(trs);
    A = A.InverseMat(dt);
  } else {
    A = rot.Matrix().TranslatedMat(trs);
  }

  // 更新された行列Aから回転ベクトルを再計算し、X3DOMビューアに反映
  rot = A.Vector();
  elm = document.getElementById('viewp001');
  elm.setAttribute('orientation', rot.ToX3DOM().toString());

  // 各表示フィールドを更新
  elm = document.getElementById('rot');
  var str = 'true,4,'+String(Math.floor(rot.x[0]*fr)/fr)+','+String(Math.floor(rot.x[1]*fr)/fr)+','+String(Math.floor(rot.x[2]*fr)/fr)+','+String(Math.floor(rot.x[3]*fr)/fr);
  elm.value = str;

  var ea = A.EulerAngle(1,2,3);
  elm = document.getElementById('rotEA');
  str = String(Math.floor(ea.x[1]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[2]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[3]*(180.0/Math.PI)*fr)/fr);
  elm.value = str;

  elm = document.getElementById('rotQT');
  str = 'true,4,'+String(Math.floor(qt.q.x[0]*fr)/fr)+','+String(Math.floor(qt.q.x[1]*fr)/fr)+','+String(Math.floor(qt.q.x[2]*fr)/fr)+','+String(Math.floor(qt.q.x[3]*fr)/fr);
  elm.value = str;

  elm = document.getElementById('rotOC');
  str = 'true,8,'+String(Math.floor(trs.x[0]*fr)/fr)+','+String(Math.floor(trs.x[1]*fr)/fr)+','+String(Math.floor(trs.x[2]*fr)/fr)+','+String(Math.floor(trs.x[3]*fr)/fr);
  str += ','+String(Math.floor(qt.q.x[0]*fr)/fr)+','+String(Math.floor(qt.q.x[1]*fr)/fr)+','+String(Math.floor(qt.q.x[2]*fr)/fr)+','+String(Math.floor(qt.q.x[3]*fr)/fr);
  elm.value = str;

  elm = document.getElementById('rotMT');
  str = 'true,4&#13;true,4,'+String(Math.floor(A.x[0].x[0]*fr)/fr)+','+String(Math.floor(A.x[0].x[1]*fr)/fr)+','+String(Math.floor(A.x[0].x[2]*fr)/fr)+','+String(Math.floor(A.x[0].x[3]*fr)/fr) +
        '&#13;true,4,'+String(Math.floor(A.x[1].x[0]*fr)/fr)+','+String(Math.floor(A.x[1].x[1]*fr)/fr)+','+String(Math.floor(A.x[1].x[2]*fr)/fr)+','+String(Math.floor(A.x[1].x[3]*fr)/fr) +
        '&#13;true,4,'+String(Math.floor(A.x[2].x[0]*fr)/fr)+','+String(Math.floor(A.x[2].x[1]*fr)/fr)+','+String(Math.floor(A.x[2].x[2]*fr)/fr)+','+String(Math.floor(A.x[2].x[3]*fr)/fr) +
        '&#13;true,4,'+String(Math.floor(A.x[3].x[0]*fr)/fr)+','+String(Math.floor(A.x[3].x[1]*fr)/fr)+','+String(Math.floor(A.x[3].x[2]*fr)/fr)+','+String(Math.floor(A.x[3].x[3]*fr)/fr);
  elm.value = str;

  // 逆行列モードの場合、内部状態の行列Aを再度逆行列に戻す
  if(radioList[0].checked) {
    A = A.InverseMat(dt);
  }
}

/**
 * ApplyXXXボタンが押されたときにビューと空間1などを復元するために呼び出される関数
 * 位置・姿勢結合ベクトル (OC) の入力が変更されたときに呼び出される関数。
 * 入力された値を元に空間1の変換行列を更新し、他の形式の変換情報も更新します。
 */
function chgrotOC(){
  // 'rotOCin'要素から入力されたOC文字列を取得し、'rotOC'要素に設定
  var elm = document.getElementById('rotOCin');
  var ro = String(elm.value);
  elm = document.getElementById('rotOC');
  elm.value = ro;

  var oc = new N6LVector().Parse(ro); // OC文字列をパース
  A = oc.PosVecMatrix(); // OCベクトルから変換行列を生成

  var radioList = document.getElementsByName("INV"); // 'INV'ラジオボタンリストを取得
  var dt = []; // 一時変数
  var rot = A.Vector(); // 行列Aから回転ベクトルを計算
  var trs = A.Pos(); // 行列Aから移動ベクトルを計算

  // ラジオボタンの選択状態に基づいて行列Aを設定（回転と移動を適用）
  if(radioList[0].checked) {
    A = rot.Matrix().TranslatedMat(trs);
    A = A.InverseMat(dt);
  } else {
    A = rot.Matrix().TranslatedMat(trs);
  }

  // 更新された行列Aから回転ベクトルを再計算し、X3DOMビューアに反映
  rot = A.Vector();
  elm = document.getElementById('viewp001');
  elm.setAttribute('orientation', rot.ToX3DOM().toString());

  // 各表示フィールドを更新
  elm = document.getElementById('rot');
  var str = 'true,4,'+String(Math.floor(rot.x[0]*fr)/fr)+','+String(Math.floor(rot.x[1]*fr)/fr)+','+String(Math.floor(rot.x[2]*fr)/fr)+','+String(Math.floor(rot.x[3]*fr)/fr);
  elm.value = str;

  elm = document.getElementById('trns');
  str = 'true,4,'+String(Math.floor(trs.x[0]*fr)/fr)+','+String(Math.floor(trs.x[1]*fr)/fr)+','+String(Math.floor(trs.x[2]*fr)/fr)+','+String(Math.floor(trs.x[3]*fr)/fr);
  elm.value = str;

  var ea = A.EulerAngle(1,2,3);
  elm = document.getElementById('rotEA');
  var str = String(Math.floor(ea.x[1]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[2]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[3]*(180.0/Math.PI)*fr)/fr);
  elm.value = str;

  var qt = A.Quaternion();
  elm = document.getElementById('rotQT');
  str = 'true,4,'+String(Math.floor(qt.q.x[0]*fr)/fr)+','+String(Math.floor(qt.q.x[1]*fr)/fr)+','+String(Math.floor(qt.q.x[2]*fr)/fr)+','+String(Math.floor(qt.q.x[3]*fr)/fr);
  elm.value = str;

  elm = document.getElementById('rotOC');
  str = 'true,8,'+String(Math.floor(trs.x[0]*fr)/fr)+','+String(Math.floor(trs.x[1]*fr)/fr)+','+String(Math.floor(trs.x[2]*fr)/fr)+','+String(Math.floor(trs.x[3]*fr)/fr);
  str += ','+String(Math.floor(qt.q.x[0]*fr)/fr)+','+String(Math.floor(qt.q.x[1]*fr)/fr)+','+String(Math.floor(qt.q.x[2]*fr)/fr)+','+String(Math.floor(qt.q.x[3]*fr)/fr);
  elm.value = str;

  elm = document.getElementById('rotMT');
  str = 'true,4&#13;true,4,'+String(Math.floor(A.x[0].x[0]*fr)/fr)+','+String(Math.floor(A.x[0].x[1]*fr)/fr)+','+String(Math.floor(A.x[0].x[2]*fr)/fr)+','+String(Math.floor(A.x[0].x[3]*fr)/fr) +
        '&#13;true,4,'+String(Math.floor(A.x[1].x[0]*fr)/fr)+','+String(Math.floor(A.x[1].x[1]*fr)/fr)+','+String(Math.floor(A.x[1].x[2]*fr)/fr)+','+String(Math.floor(A.x[1].x[3]*fr)/fr) +
        '&#13;true,4,'+String(Math.floor(A.x[2].x[0]*fr)/fr)+','+String(Math.floor(A.x[2].x[1]*fr)/fr)+','+String(Math.floor(A.x[2].x[2]*fr)/fr)+','+String(Math.floor(A.x[2].x[3]*fr)/fr) +
        '&#13;true,4,'+String(Math.floor(A.x[3].x[0]*fr)/fr)+','+String(Math.floor(A.x[3].x[1]*fr)/fr)+','+String(Math.floor(A.x[3].x[2]*fr)/fr)+','+String(Math.floor(A.x[3].x[3]*fr)/fr);
  elm.value = str;

  // 逆行列モードの場合、内部状態の行列Aを再度逆行列に戻す
  if(radioList[0].checked) {
    A = A.InverseMat(dt);
  }
}

/**
 * ApplyXXXボタンが押されたときにビューと空間1などを復元するために呼び出される関数
 * 行列の入力が変更されたときに呼び出される関数。
 * 入力された値を元に空間1の変換行列を更新し、他の形式の変換情報も更新します。
 */
function chgrotMT(){
  // 'rotMTin'要素から入力された行列文字列を取得し、'rotMT'要素に設定
  var elm = document.getElementById('rotMTin');
  var ro = String(elm.value);
  elm = document.getElementById('rotMT');
  elm.value = ro;
  ro = ro.replace(/\n/g, " "); // 改行コードをスペースに置換

  A = new N6LMatrix().Parse(ro); // 文字列からN6LMatrixオブジェクトをパース

  var radioList = document.getElementsByName("INV"); // 'INV'ラジオボタンリストを取得
  var dt = []; // 一時変数
  var rot = A.Vector(); // 行列Aから回転ベクトルを計算
  var trs = A.Pos(); // 行列Aから移動ベクトルを計算

  // ラジオボタンの選択状態に基づいて行列Aを設定（回転と移動を適用）
  if(radioList[0].checked) {
    A = rot.Matrix().TranslatedMat(trs);
    A = A.InverseMat(dt);
  } else {
    A = rot.Matrix().TranslatedMat(trs);
  }

  // 更新された行列Aから回転ベクトルを再計算し、X3DOMビューアに反映
  rot = A.Vector();
  elm = document.getElementById('viewp001');
  elm.setAttribute('orientation', rot.ToX3DOM().toString());

  // 各表示フィールドを更新
  elm = document.getElementById('rot');
  var str = 'true,4,'+String(Math.floor(rot.x[0]*fr)/fr)+','+String(Math.floor(rot.x[1]*fr)/fr)+','+String(Math.floor(rot.x[2]*fr)/fr)+','+String(Math.floor(rot.x[3]*fr)/fr);
  elm.value = str;

  elm = document.getElementById('trns');
  str = 'true,4,'+String(Math.floor(trs.x[0]*fr)/fr)+','+String(Math.floor(trs.x[1]*fr)/fr)+','+String(Math.floor(trs.x[2]*fr)/fr)+','+String(Math.floor(trs.x[3]*fr)/fr);
  elm.value = str;

  var ea = A.EulerAngle(1,2,3);
  elm = document.getElementById('rotEA');
  var str = String(Math.floor(ea.x[1]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[2]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[3]*(180.0/Math.PI)*fr)/fr);
  elm.value = str;

  var qt = A.Quaternion();
  elm = document.getElementById('rotQT');
  str = 'true,4,'+String(Math.floor(qt.q.x[0]*fr)/fr)+','+String(Math.floor(qt.q.x[1]*fr)/fr)+','+String(Math.floor(qt.q.x[2]*fr)/fr)+','+String(Math.floor(qt.q.x[3]*fr)/fr);
  elm.value = str;

  elm = document.getElementById('rotOC');
  str = 'true,8,'+String(Math.floor(trs.x[0]*fr)/fr)+','+String(Math.floor(trs.x[1]*fr)/fr)+','+String(Math.floor(trs.x[2]*fr)/fr)+','+String(Math.floor(trs.x[3]*fr)/fr);
  str += ','+String(Math.floor(qt.q.x[0]*fr)/fr)+','+String(Math.floor(qt.q.x[1]*fr)/fr)+','+String(Math.floor(qt.q.x[2]*fr)/fr)+','+String(Math.floor(qt.q.x[3]*fr)/fr);
  elm.value = str;

  elm = document.getElementById('rotMT');
  str = 'true,4&#13;true,4,'+String(Math.floor(A.x[0].x[0]*fr)/fr)+','+String(Math.floor(A.x[0].x[1]*fr)/fr)+','+String(Math.floor(A.x[0].x[2]*fr)/fr)+','+String(Math.floor(A.x[0].x[3]*fr)/fr) +
        '&#13;true,4,'+String(Math.floor(A.x[1].x[0]*fr)/fr)+','+String(Math.floor(A.x[1].x[1]*fr)/fr)+','+String(Math.floor(A.x[1].x[2]*fr)/fr)+','+String(Math.floor(A.x[1].x[3]*fr)/fr) +
        '&#13;true,4,'+String(Math.floor(A.x[2].x[0]*fr)/fr)+','+String(Math.floor(A.x[2].x[1]*fr)/fr)+','+String(Math.floor(A.x[2].x[2]*fr)/fr)+','+String(Math.floor(A.x[2].x[3]*fr)/fr) +
        '&#13;true,4,'+String(Math.floor(A.x[3].x[0]*fr)/fr)+','+String(Math.floor(A.x[3].x[1]*fr)/fr)+','+String(Math.floor(A.x[3].x[2]*fr)/fr)+','+String(Math.floor(A.x[3].x[3]*fr)/fr);
  elm.value = str;

  // 逆行列モードの場合、内部状態の行列Aを再度逆行列に戻す
  if(radioList[0].checked) {
    A = A.InverseMat(dt);
  }
}

/**
 * applyボタンがクリックされたときに呼び出される関数。
 * 空間1 (現在のビュー変換行列) の値を空間2 (A2) にコピーします。
 */
function apply(){
  // 空間1の移動量、回転ベクトル、オイラー角、クォータニオン、OC、行列の値を
  // それぞれ対応する空間2の表示要素にコピー
  var elm = document.getElementById('trns');
  var str = String(elm.value);
  elm = document.getElementById('trns2');
  elm.value = str;

  elm = document.getElementById('rot');
  str = String(elm.value);
  elm = document.getElementById('rot2');
  elm.value = str;

  elm = document.getElementById('rotEA');
  str = String(elm.value);
  elm = document.getElementById('rot2EA');
  elm.value = str;

  elm = document.getElementById('rotQT');
  str = String(elm.value);
  elm = document.getElementById('rot2QT');
  elm.value = str;

  elm = document.getElementById('rotOC');
  str = String(elm.value);
  elm = document.getElementById('rot2OC');
  elm.value = str;

  elm = document.getElementById('rotMT');
  str = String(elm.value);
  elm = document.getElementById('rot2MT');
  elm.value = str;

  // 空間1の行列Aの値を空間2の行列A2にコピー
  A2 = new N6LMatrix(A);
}

/**
 * copyボタンがクリックされたときに呼び出される関数。
 * 空間1 (現在のビュー変換行列) の値を入力空間 (in系のテキストボックス) にコピーします。
 */
function copy(){
  // 空間1の移動量、回転ベクトル、オイラー角、クォータニオン、OC、行列の値を
  // それぞれ対応する入力空間の要素にコピー
  var elm = document.getElementById('trns');
  var str = String(elm.value);
  elm = document.getElementById('trnsin');
  elm.value = str;

  elm = document.getElementById('rot');
  str = String(elm.value);
  elm = document.getElementById('rotin');
  elm.value = str;

  elm = document.getElementById('rotEA');
  str = String(elm.value);
  elm = document.getElementById('rotEAin');
  elm.value = str;

  elm = document.getElementById('rotQT');
  str = String(elm.value);
  elm = document.getElementById('rotQTin');
  elm.value = str;

  elm = document.getElementById('rotOC');
  str = String(elm.value);
  elm = document.getElementById('rotOCin');
  elm.value = str;

  elm = document.getElementById('rotMT');
  str = String(elm.value);
  elm = document.getElementById('rotMTin');
  elm.value = str;
}

// jQueryのdocument.ready関数: DOMが完全にロードされた後に実行される
jQuery(document).ready(function(){
  TMan.add(); // タイマーマネージャーに新しいタイマーを追加
  // メインループ (GLoop) を50ミリ秒ごとに実行するように設定
  TMan.timer[0].setalerm(function() { GLoop(0); }, 50);
});

var be = true; // 入力フィールドの有効/無効状態を管理するフラグ

/**
 * inputボタンがクリックされたときに呼び出される関数。
 * 入力空間・フォームのキーボード/マウス入力の有効/無効を切り替えます。
 * (テキストボックスの背景色を変更し、キーボード入力を制御)
 */
function input(){
  var str;
  if(be) str = 'rgb(255,255,255)'; // 有効な場合は白
  else str = 'rgb(136,136,136)'; // 無効な場合はグレー

  // 各入力フィールドの背景色を設定
  var elm = document.getElementById('trnsin');
  elm.style.backgroundColor = str;
  elm = document.getElementById('rotin');
  elm.style.backgroundColor = str;
  elm = document.getElementById('rotEAin');
  elm.style.backgroundColor = str;
  elm = document.getElementById('rotQTin');
  elm.style.backgroundColor = str;
  elm = document.getElementById('rotOCin');
  elm.style.backgroundColor = str;
  elm = document.getElementById('rotMTin');
  elm.style.backgroundColor = str;

  // beフラグを反転
  if(be) be = false;
  else be = true;
  // キーボード入力を有効/無効に設定
  KeyB.setenable(be);
}

var FF=true; // 初期化処理を一度だけ行うためのフラグ

/**
 * メインループ関数 (GLoop)。
 * X3DOMのビュー変換行列を取得し、空間1に設定。
 * 空間1と空間2の行列を乗算し、空間3（A3）としてその結果を計算・表示します。
 * 各種変換形式（回転ベクトル、オイラー角、クォータニオン、行列、OC）での表示も更新します。
 * @param {number} id - タイマーID
 */
function GLoop(id){
  // X3DOMランタイムがまだ初期化されていない場合は、初期化されるまで待機
  if(x3domRuntime == undefined) {
    x3domRuntime = document.getElementById('x3dabs').runtime;
    TMan.timer[id].setalerm(function() { GLoop(id); }, 50); // 50ミリ秒後にメインループを再設定
    return;
  }

  var elm = document.getElementById('viewp001');

  // X3DOMのビュー行列の逆行列（ワールド変換行列）を取得し、A (空間1) に設定
  var SWM = x3domRuntime.viewMatrix().inverse();
  A = new N6LMatrix().FromX3DOM(SWM);

  var radioList = document.getElementsByName("INV"); // 'INV'ラジオボタンリストを取得
  var dt = []; // 一時変数
  var rot = A.Vector(); // 行列Aから回転ベクトルを計算

  // 'trns'要素から移動量を取得（ここでは表示されている値を使用）
  elm = document.getElementById('trns');
  var tr = String(elm.value);
  var trs = new N6LVector().Parse(tr); // 移動ベクトルをパース

  // ラジオボタンの選択状態に基づいて行列Aを設定（回転と移動を適用）
  if(radioList[0].checked) {
    A = rot.Matrix().TranslatedMat(trs);
    A = A.InverseMat(dt);
  } else {
    A = rot.Matrix().TranslatedMat(trs);
  }

  // 空間3 (A3) = 空間1 (A) と空間2 (A2) の行列の積（変換の合成）を計算
  var A3 = A.Mul(A2);

  // --- 空間3の各表示フィールドを更新 ---

  // 空間3のオイラー角を計算し、'rot3EA'要素に設定
  var ea = A3.EulerAngle(1,2,3);
  var elm = document.getElementById('rot3EA');
  var str = String(Math.floor(ea.x[1]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[2]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[3]*(180.0/Math.PI)*fr)/fr);
  elm.value = str;

  // 空間3の移動量を計算し、'trns3'要素に設定
  var trs3 = A3.Pos();
  elm = document.getElementById('trns3');
  str = 'true,4,'+String(Math.floor(trs3.x[0]*fr)/fr)+','+String(Math.floor(trs3.x[1]*fr)/fr)+','+String(Math.floor(trs3.x[2]*fr)/fr)+','+String(Math.floor(trs3.x[3]*fr)/fr);
  elm.value = str;

  // 空間3の回転ベクトルを計算し、'rot3'要素に設定
  var rot3 = A3.Vector();
  elm = document.getElementById('rot3');
  str = 'true,4,'+String(Math.floor(rot3.x[0]*fr)/fr)+','+String(Math.floor(rot3.x[1]*fr)/fr)+','+String(Math.floor(rot3.x[2]*fr)/fr)+','+String(Math.floor(rot3.x[3]*fr)/fr);
  elm.value = str;

  // 空間3のクォータニオンを計算し、'rot3QT'要素に設定
  var qt3 = A3.Quaternion();
  elm = document.getElementById('rot3QT');
  str = 'true,4,'+String(Math.floor(qt3.q.x[0]*fr)/fr)+','+String(Math.floor(qt3.q.x[1]*fr)/fr)+','+String(Math.floor(qt3.q.x[2]*fr)/fr)+','+String(Math.floor(qt3.q.x[3]*fr)/fr);
  elm.value = str;

  // 空間3の位置・姿勢結合ベクトル (OC) を計算し、'rot3OC'要素に設定
  str = 'true,8,'+String(Math.floor(trs3.x[0]*fr)/fr)+','+String(Math.floor(trs3.x[1]*fr)/fr)+','+String(Math.floor(trs3.x[2]*fr)/fr)+','+String(Math.floor(trs3.x[3]*fr)/fr);
  str += ','+String(Math.floor(qt3.q.x[0]*fr)/fr)+','+String(Math.floor(qt3.q.x[1]*fr)/fr)+','+String(Math.floor(qt3.q.x[2]*fr)/fr)+','+String(Math.floor(qt3.q.x[3]*fr)/fr);
  elm.value = str;

  // 空間3の行列成分を'rot3MT'要素に設定
  elm = document.getElementById('rot3MT');
  str = 'true,4\ntrue,4,'+String(Math.floor(A3.x[0].x[0]*fr)/fr)+','+String(Math.floor(A3.x[0].x[1]*fr)/fr)+','+String(Math.floor(A3.x[0].x[2]*fr)/fr)+','+String(Math.floor(A3.x[0].x[3]*fr)/fr) +
        '\ntrue,4,'+String(Math.floor(A3.x[1].x[0]*fr)/fr)+','+String(Math.floor(A3.x[1].x[1]*fr)/fr)+','+String(Math.floor(A3.x[1].x[2]*fr)/fr)+','+String(Math.floor(A3.x[1].x[3]*fr)/fr) +
        '\ntrue,4,'+String(Math.floor(A3.x[2].x[0]*fr)/fr)+','+String(Math.floor(A3.x[2].x[1]*fr)/fr)+','+String(Math.floor(A3.x[2].x[2]*fr)/fr)+','+String(Math.floor(A3.x[2].x[3]*fr)/fr) +
        '\ntrue,4,'+String(Math.floor(A3.x[3].x[0]*fr)/fr)+','+String(Math.floor(A3.x[3].x[1]*fr)/fr)+','+String(Math.floor(A3.x[3].x[2]*fr)/fr)+','+String(Math.floor(A3.x[3].x[3]*fr)/fr);
  elm.innerText = str; // innerTextも設定
  elm.value = str; // valueも設定

  // --- 空間1の各表示フィールドを更新 ---

  // 空間1のオイラー角を計算し、'rotEA'要素に設定
  ea = A.EulerAngle(1,2,3);
  elm = document.getElementById('rotEA');
  str = String(Math.floor(ea.x[1]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[2]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[3]*(180.0/Math.PI)*fr)/fr);
  elm.value = str;

  // 空間1の移動量を計算し、'trns'要素に設定
  trs = A.Pos();
  elm = document.getElementById('trns');
  str = 'true,4,'+String(Math.floor(trs.x[0]*fr)/fr)+','+String(Math.floor(trs.x[1]*fr)/fr)+','+String(Math.floor(trs.x[2]*fr)/fr)+','+String(Math.floor(trs.x[3]*fr)/fr);
  elm.value = str;

  // 空間1の回転ベクトルを計算し、'rot'要素に設定
  rot = A.Vector();
  elm = document.getElementById('rot');
  str = 'true,4,'+String(Math.floor(rot.x[0]*fr)/fr)+','+String(Math.floor(rot.x[1]*fr)/fr)+','+String(Math.floor(rot.x[2]*fr)/fr)+','+String(Math.floor(rot.x[3]*fr)/fr);
  elm.value = str;

  // 空間1のクォータニオンを計算し、'rotQT'要素に設定
  qt = A.Quaternion();
  elm = document.getElementById('rotQT');
  str = 'true,4,'+String(Math.floor(qt.q.x[0]*fr)/fr)+','+String(Math.floor(qt.q.x[1]*fr)/fr)+','+String(Math.floor(qt.q.x[2]*fr)/fr)+','+String(Math.floor(qt.q.x[3]*fr)/fr);
  elm.value = str;

  // 空間1の位置・姿勢結合ベクトル (OC) を計算し、'rotOC'要素に設定
  elm = document.getElementById('rotOC');
  str = 'true,8,'+String(Math.floor(trs.x[0]*fr)/fr)+','+String(Math.floor(trs.x[1]*fr)/fr)+','+String(Math.floor(trs.x[2]*fr)/fr)+','+String(Math.floor(trs.x[3]*fr)/fr);
  str += ','+String(Math.floor(qt.q.x[0]*fr)/fr)+','+String(Math.floor(qt.q.x[1]*fr)/fr)+','+String(Math.floor(qt.q.x[2]*fr)/fr)+','+String(Math.floor(qt.q.x[3]*fr)/fr);
  elm.value = str;

  // 空間1の行列成分を'rotMT'要素に設定
  elm = document.getElementById('rotMT');
  str = 'true,4\ntrue,4,'+String(Math.floor(A.x[0].x[0]*fr)/fr)+','+String(Math.floor(A.x[0].x[1]*fr)/fr)+','+String(Math.floor(A.x[0].x[2]*fr)/fr)+','+String(Math.floor(A.x[0].x[3]*fr)/fr) +
        '\ntrue,4,'+String(Math.floor(A.x[1].x[0]*fr)/fr)+','+String(Math.floor(A.x[1].x[1]*fr)/fr)+','+String(Math.floor(A.x[1].x[2]*fr)/fr)+','+String(Math.floor(A.x[1].x[3]*fr)/fr) +
        '\ntrue,4,'+String(Math.floor(A.x[2].x[0]*fr)/fr)+','+String(Math.floor(A.x[2].x[1]*fr)/fr)+','+String(Math.floor(A.x[2].x[2]*fr)/fr)+','+String(Math.floor(A.x[2].x[3]*fr)/fr) +
        '\ntrue,4,'+String(Math.floor(A.x[3].x[0]*fr)/fr)+','+String(Math.floor(A.x[3].x[1]*fr)/fr)+','+String(Math.floor(A.x[3].x[2]*fr)/fr)+','+String(Math.floor(A.x[3].x[3]*fr)/fr);
  elm.innerText = str;
  elm.value = str;

  // --- 位置・姿勢結合ベクトル (OC) の掛け算結果 (rot3COC) を更新 ---
  // 空間1のOCと空間2のOC (rot2OCinの値) を乗算し、結果を'rot3COC'に表示
  elm = document.getElementById('rotOC');
  var stroc = String(elm.value);
  var oc = new N6LVector().Parse(stroc); // 空間1のOCをパース

  elm = document.getElementById('rot2OC'); // 空間2のOCは、apply()で設定されたrot2OCの値を参照
  var stroc2 = String(elm.value);
  var oc2 = new N6LVector().Parse(stroc2); // 空間2のOCをパース

  var oc3=oc.PosVecMul(oc2); // 空間1のOCと空間2のOCを乗算
  elm = document.getElementById('rot3COC');
  str = 'true,8,'+String(Math.floor(oc3.x[0]*fr)/fr)+','+String(Math.floor(oc3.x[1]*fr)/fr)+','+String(Math.floor(oc3.x[2]*fr)/fr)+','+String(Math.floor(oc3.x[3]*fr)/fr);
  str += ','+String(Math.floor(oc3.x[4]*fr)/fr)+','+String(Math.floor(oc3.x[5]*fr)/fr)+','+String(Math.floor(oc3.x[6]*fr)/fr)+','+String(Math.floor(oc3.x[7]*fr)/fr);
  elm.value = str;


  // 逆行列モードの場合、内部状態の行列Aを再度逆行列に戻す（ここでは処理なし）
  if(radioList[0].checked) {
    ; // 何もしない
  } else {
    A = A.InverseMat(dt); // 通常モードの場合、Aを逆行列に戻す（なぜここで逆行列に戻すのかは要確認、前の処理と一貫させるためか）
  }

  // 初回実行時のみapply()を呼び出し、空間1の初期値を空間2にコピー
  if(FF){
    FF=false;
    apply();
  }

  // 空間3の逆行列から位置と回転を抽出し、X3DOMの特定のオブジェクト（oniT0, oniR0）に適用
  // この部分はX3DOMオブジェクトを動かして、空間3の変換を視覚的に表現している
  // テスト実装コードであり現在は使われていません
  var p = A3.InverseMat(dt).Pos(); // 空間3の逆行列からの位置
  var o = A3.InverseMat(dt).Vector(); // 空間3の逆行列からの回転ベクトル

  elm = document.getElementById('oniT0');
  elm.setAttribute('translation', p.ToX3DOM(true).toString()); // オブジェクトの位置を設定
  elm = document.getElementById('oniR0');
  elm.setAttribute('rotation', o.ToX3DOM().toString()); // オブジェクトの回転を設定
  elm.setAttribute('render', 'true'); // オブジェクトをレンダリング（表示）

  TMan.timer[id].setalerm(function() { GLoop(id); }, 50); // 50ミリ秒後にメインループを再設定
}

/**
 * キーボード入力のチェックと3Dビューの回転を行う関数。
 * テンキーの2, 8, 4, 6, 1, 3を使ってピッチ、ヨー、ロールを調整し、ビューアに反映します。
 */
function chkKeyBoard(){
  var b = false; // キーが押されたかどうかのフラグ
  var p = 0.0; // ピッチ (X軸周り) の変化量
  var y = 0.0; // ヨー (Y軸周り) の変化量
  var r = 0.0; // ロール (Z軸周り) の変化量
  var ad = 0.05; // 回転の増分 (ラジアン)

  // テンキーの2 (下) が押された場合: ピッチを減少
  if(KeyB.keystate[KeyB.indexof(KeyB.ToReal('VK_N2'))]) {
    b = true;
    p -= ad;
  }
  // テンキーの8 (上) が押された場合: ピッチを増加
  if(KeyB.keystate[KeyB.indexof(KeyB.ToReal('VK_N8'))]) {
    b = true;
    p += ad;
  }
  // テンキーの4 (左) が押された場合: ヨーを減少
  if(KeyB.keystate[KeyB.indexof(KeyB.ToReal('VK_N4'))]) {
    b = true;
    y -= ad;
  }
  // テンキーの6 (右) が押された場合: ヨーを増加
  if(KeyB.keystate[KeyB.indexof(KeyB.ToReal('VK_N6'))]) {
    b = true;
    y += ad;
  }
  // テンキーの1 (左下) が押された場合: ロールを減少
  if(KeyB.keystate[KeyB.indexof(KeyB.ToReal('VK_N1'))]) {
    b = true;
    r -= ad;
  }
  // テンキーの3 (右下) が押された場合: ロールを増加
  if(KeyB.keystate[KeyB.indexof(KeyB.ToReal('VK_N3'))]) {
    b = true;
    r += ad;
  }

  // いずれかのキーが押された場合
  if(b) {
    var dt = []; // 一時変数
    var rot = A.Vector(); // 現在の空間1行列Aから回転ベクトルを取得

    // 行列Aを回転ベクトルから再構築し、その逆行列を取得 (X3DOMのビュー行列の仕様に合わせるためか)
    A = rot.Matrix();
    A = A.InverseMat(dt);

    // ピッチ、ヨー、ロールの増分を含む新しいN6LVectorを生成
    var wpyr = new N6LVector([1, p, y, r], true);
    var outmat = []; // 出力行列用 (MoveMatの引数)
    var outv = []; // 出力ベクトル用 (MoveMatの引数)

    // 現在の行列Aにキーボード入力による回転増分を適用して新しい行列Aを計算
    // MoveMat関数は、移動、回転、スケールなどを適用する汎用関数と思われる
    A = A.MoveMat(outmat, outv, new N6LVector(4, true).ZeroVec(), wpyr, 0, 0, 0, 0); // 目的の関数

    // 更新された行列Aから回転ベクトルを再計算
    rot = A.Vector();
    // 'viewp001'要素のorientation属性をX3DOM形式の回転ベクトルで更新し、3Dビューに反映
    var elm = document.getElementById('viewp001');
    elm.setAttribute('orientation', rot.ToX3DOM().toString());

    // 行列Aの逆行列を再計算 (内部状態を一致させるためか、次のループでの処理に備えるため)
    A = A.InverseMat(dt);
  }
};




