﻿var chk = false;
var TMan = new N6LTimerMan(); // タイマーマネージャーのインスタンス
var x3domRuntime; // X3DOMランタイムオブジェクトを保持する変数

var fr = 1000; // 浮動小数点数を丸めるための係数 (1000で小数点以下3桁まで表示)
var A = new N6LMatrix(4).UnitMat(); // 現在のビュー回転行列 (4x4の単位行列で初期化)

//SwDefCoodinate = 1;//逆行列を求める方法の選択スイッチ

/**
 * ApllyXXXで回転状態を復元するときに呼び出される関数
 * 回転ベクトル (Axis-Angle) の入力が変更されたときに呼び出される関数。
 * 入力された回転ベクトルを元にビュー行列を更新し、他の形式の回転情報も更新します。
 */
function chgrotVec(){
  // 'rotin'要素から入力された回転ベクトル文字列を取得
  var elm = document.getElementById('rotin');
  var ro = String(elm.value);
  // 'rot'要素に同じ値を設定
  elm = document.getElementById('rot');
  elm.value = ro;
  // 文字列からN6LVectorオブジェクトをパース
  var rot = new N6LVector().Parse(ro);

  // 'INV'という名前のラジオボタンリストを取得
  var radioList = document.getElementsByName("INV");
  var dt = []; // 逆行列計算時に使用される可能性のある一時変数

  // ラジオボタンの選択状態に基づいて行列Aを設定
  if(radioList[0].checked) { // 最初のラジオボタンがチェックされている場合（おそらく逆行列モード）
    A = rot.Matrix(); // 回転ベクトルから行列を生成
    A = A.InverseMat(dt); // 生成した行列の逆行列を計算
  } else { // それ以外の場合（通常モード）
    A = rot.Matrix(); // 回転ベクトルから行列を生成
  }

  // 更新された行列Aから回転ベクトルを再計算
  rot = A.Vector();
  // 'viewp001'要素のorientation属性をX3DOM形式の回転ベクトルで更新し、3Dビューに反映
  elm = document.getElementById('viewp001');
  elm.setAttribute('orientation', rot.ToX3DOM().toString());

  // 行列Aからオイラー角を計算 (1, 2, 3はx,y,z回転軸の順序)
  var ea = A.EulerAngle(1,2,3);
  // 'rotEA'要素に計算されたオイラー角を設定
  elm = document.getElementById('rotEA');
  // オイラー角を度数法に変換し、frで丸めて文字列に変換
  var str = String(Math.floor(ea.x[1]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[2]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[3]*(180.0/Math.PI)*fr)/fr);
  elm.value = str;

  // 行列Aからクォータニオンを計算
  var qt = A.Quaternion();
  // 'rotQT'要素に計算されたクォータニオンを設定
  elm = document.getElementById('rotQT');
  // クォータニオンの成分をfrで丸めて文字列に変換
  str = 'true,4,'+String(Math.floor(qt.q.x[0]*fr)/fr)+','+String(Math.floor(qt.q.x[1]*fr)/fr)+','+String(Math.floor(qt.q.x[2]*fr)/fr)+','+String(Math.floor(qt.q.x[3]*fr)/fr);
  elm.value = str;

  // 'rotMT'要素に計算された行列を設定
  elm = document.getElementById('rotMT');
  // 行列の各成分をfrで丸めて、改行コードを含む文字列に変換
  str = 'true,4&#13;true,4,'+String(Math.floor(A.x[0].x[0]*fr)/fr)+','+String(Math.floor(A.x[0].x[1]*fr)/fr)+','+String(Math.floor(A.x[0].x[2]*fr)/fr)+','+String(Math.floor(A.x[0].x[3]*fr)/fr) +
        '&#13;true,4,'+String(Math.floor(A.x[1].x[0]*fr)/fr)+','+String(Math.floor(A.x[1].x[1]*fr)/fr)+','+String(Math.floor(A.x[1].x[2]*fr)/fr)+','+String(Math.floor(A.x[1].x[3]*fr)/fr) +
        '&#13;true,4,'+String(Math.floor(A.x[2].x[0]*fr)/fr)+','+String(Math.floor(A.x[2].x[1]*fr)/fr)+','+String(Math.floor(A.x[2].x[2]*fr)/fr)+','+String(Math.floor(A.x[2].x[3]*fr)/fr) +
        '&#13;true,4,'+String(Math.floor(A.x[3].x[0]*fr)/fr)+','+String(Math.floor(A.x[3].x[1]*fr)/fr)+','+String(Math.floor(A.x[3].x[2]*fr)/fr)+','+String(Math.floor(A.x[3].x[3]*fr)/fr);
  elm.value = str;

  // 再度ラジオボタンの選択状態を確認し、必要であれば逆行列を再計算
  if(radioList[0].checked) {
    A = A.InverseMat(dt);
  }
}

/**
 * ApllyXXXで回転状態を復元するときに呼び出される関数
 * オイラー角の入力が変更されたときに呼び出される関数。
 * 入力されたオイラー角を元にビュー行列を更新し、他の形式の回転情報も更新します。
 */
function chgrotEA(){
  // 'rotEAin'要素から入力されたオイラー角文字列を取得
  var elm = document.getElementById('rotEAin');
  var roEA = String(elm.value);
  // 'rotEA'要素に同じ値を設定
  elm = document.getElementById('rotEA');
  elm.value = roEA;
  // カンマで分割して各オイラー角の値を取得
  var tk = roEA.split(',');
  // N6LVectorオブジェクトとしてオイラー角を生成（ラジアンに変換）
  var ea = new N6LVector([1,Number(tk[0])*(Math.PI/180.0),Number(tk[1])*(Math.PI/180.0),Number(tk[2])*(Math.PI/180.0)],true);

  // 単位ベクトルを生成
  var ax = new N6LVector(4,true).UnitVec(1); // X軸
  var ay = new N6LVector(4,true).UnitVec(2); // Y軸
  var az = new N6LVector(4,true).UnitVec(3); // Z軸

  // 単位行列から開始し、各軸周りにオイラー角で回転を適用
  A = A.UnitMat().RotAxis(ax,ea.x[1]); // X軸周りの回転
  ay = A.GetRow(2); // 回転後のY軸ベクトルを取得
  A = A.RotAxis(ay,ea.x[2]); // 新しいY軸周りの回転
  az = A.GetRow(3); // 回転後のZ軸ベクトルを取得
  A = A.RotAxis(az,ea.x[3]); // 新しいZ軸周りの回転

  // 'INV'という名前のラジオボタンリストを取得
  var radioList = document.getElementsByName("INV");
  var rot = A.Vector(); // 行列Aから回転ベクトルを計算
  var dt = []; // 逆行列計算時に使用される可能性のある一時変数

  // ラジオボタンの選択状態に基づいて行列Aを設定
  if(radioList[0].checked) { // 最初のラジオボタンがチェックされている場合（おそらく逆行列モード）
    A = rot.Matrix(); // 回転ベクトルから行列を生成
    A = A.InverseMat(dt); // 生成した行列の逆行列を計算
  } else { // それ以外の場合（通常モード）
    A = rot.Matrix(); // 回転ベクトルから行列を生成
  }

  // 更新された行列Aから回転ベクトルを再計算
  rot = A.Vector();
  // 'viewp001'要素のorientation属性をX3DOM形式の回転ベクトルで更新
  elm = document.getElementById('viewp001');
  elm.setAttribute('orientation', rot.ToX3DOM().toString());

  // 'rot'要素に計算された回転ベクトルを設定
  elm = document.getElementById('rot');
  // 回転ベクトルの成分をfrで丸めて文字列に変換
  var str = 'true,4,'+String(Math.floor(rot.x[0]*fr)/fr)+','+String(Math.floor(rot.x[1]*fr)/fr)+','+String(Math.floor(rot.x[2]*fr)/fr)+','+String(Math.floor(rot.x[3]*fr)/fr);
  elm.value = str;

  // 行列Aからクォータニオンを計算
  var qt = A.Quaternion();
  // 'rotQT'要素に計算されたクォータニオンを設定
  elm = document.getElementById('rotQT');
  // クォータニオンの成分をfrで丸めて文字列に変換
  str = 'true,4,'+String(Math.floor(qt.q.x[0]*fr)/fr)+','+String(Math.floor(qt.q.x[1]*fr)/fr)+','+String(Math.floor(qt.q.x[2]*fr)/fr)+','+String(Math.floor(qt.q.x[3]*fr)/fr);
  elm.value = str;

  // 'rotMT'要素に計算された行列を設定
  elm = document.getElementById('rotMT');
  // 行列の各成分をfrで丸めて、改行コードを含む文字列に変換
  str = 'true,4&#13;true,4,'+String(Math.floor(A.x[0].x[0]*fr)/fr)+','+String(Math.floor(A.x[0].x[1]*fr)/fr)+','+String(Math.floor(A.x[0].x[2]*fr)/fr)+','+String(Math.floor(A.x[0].x[3]*fr)/fr) +
        '&#13;true,4,'+String(Math.floor(A.x[1].x[0]*fr)/fr)+','+String(Math.floor(A.x[1].x[1]*fr)/fr)+','+String(Math.floor(A.x[1].x[2]*fr)/fr)+','+String(Math.floor(A.x[1].x[3]*fr)/fr) +
        '&#13;true,4,'+String(Math.floor(A.x[2].x[0]*fr)/fr)+','+String(Math.floor(A.x[2].x[1]*fr)/fr)+','+String(Math.floor(A.x[2].x[2]*fr)/fr)+','+String(Math.floor(A.x[2].x[3]*fr)/fr) +
        '&#13;true,4,'+String(Math.floor(A.x[3].x[0]*fr)/fr)+','+String(Math.floor(A.x[3].x[1]*fr)/fr)+','+String(Math.floor(A.x[3].x[2]*fr)/fr)+','+String(Math.floor(A.x[3].x[3]*fr)/fr);
  elm.value = str;

  // 再度ラジオボタンの選択状態を確認し、必要であれば逆行列を再計算
  if(radioList[0].checked) {
    A = A.InverseMat(dt);
  }
}


/**
 * ApllyXXXで回転状態を復元するときに呼び出される関数
 * クォータニオンの入力が変更されたときに呼び出される関数。
 * 入力されたクォータニオンを元にビュー行列を更新し、他の形式の回転情報も更新します。
 */
function chgrotQT(){
  // 'rotQTin'要素から入力されたクォータニオン文字列を取得
  var elm = document.getElementById('rotQTin');
  var ro = String(elm.value);
  // 'rotQT'要素に同じ値を設定
  elm = document.getElementById('rotQT');
  elm.value = ro;
  // 文字列からN6LQuaternionオブジェクトをパース
  var qt = new N6LQuaternion().Parse(ro);

  var dt = []; // 逆行列計算時に使用される可能性のある一時変数
  A = qt.Matrix(); // クォータニオンから行列を生成
  var rot = A.Vector(); // 生成した行列から回転ベクトルを計算

  // 'INV'という名前のラジオボタンリストを取得
  var radioList = document.getElementsByName("INV");
  // ラジオボタンの選択状態に基づいて行列Aを設定
  if(radioList[0].checked) { // 最初のラジオボタンがチェックされている場合（おそらく逆行列モード）
    A = rot.Matrix(); // 回転ベクトルから行列を生成
    A = A.InverseMat(dt); // 生成した行列の逆行列を計算
  } else { // それ以外の場合（通常モード）
    A = rot.Matrix(); // 回転ベクトルから行列を生成
  }

  // 更新された行列Aから回転ベクトルを再計算
  rot = A.Vector();
  // 'viewp001'要素のorientation属性をX3DOM形式の回転ベクトルで更新
  elm = document.getElementById('viewp001');
  elm.setAttribute('orientation', rot.ToX3DOM().toString());

  // 'rot'要素に計算された回転ベクトルを設定
  elm = document.getElementById('rot');
  // 回転ベクトルの成分をfrで丸めて文字列に変換
  var str = 'true,4,'+String(Math.floor(rot.x[0]*fr)/fr)+','+String(Math.floor(rot.x[1]*fr)/fr)+','+String(Math.floor(rot.x[2]*fr)/fr)+','+String(Math.floor(rot.x[3]*fr)/fr);
  elm.value = str;

  // 行列Aからオイラー角を計算
  var ea = A.EulerAngle(1,2,3);
  // 'rotEA'要素に計算されたオイラー角を設定
  elm = document.getElementById('rotEA');
  // オイラー角を度数法に変換し、frで丸めて文字列に変換
  str = String(Math.floor(ea.x[1]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[2]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[3]*(180.0/Math.PI)*fr)/fr);
  elm.value = str;

  // 'rotQT'要素に計算されたクォータニオンを設定
  elm = document.getElementById('rotQT');
  // クォータニオンの成分をfrで丸めて文字列に変換
  str = 'true,4,'+String(Math.floor(qt.q.x[0]*fr)/fr)+','+String(Math.floor(qt.q.x[1]*fr)/fr)+','+String(Math.floor(qt.q.x[2]*fr)/fr)+','+String(Math.floor(qt.q.x[3]*fr)/fr);
  elm.value = str;

  // 'rotMT'要素に計算された行列を設定
  elm = document.getElementById('rotMT');
  // 行列の各成分をfrで丸めて、改行コードを含む文字列に変換
  str = 'true,4&#13;true,4,'+String(Math.floor(A.x[0].x[0]*fr)/fr)+','+String(Math.floor(A.x[0].x[1]*fr)/fr)+','+String(Math.floor(A.x[0].x[2]*fr)/fr)+','+String(Math.floor(A.x[0].x[3]*fr)/fr) +
        '&#13;true,4,'+String(Math.floor(A.x[1].x[0]*fr)/fr)+','+String(Math.floor(A.x[1].x[1]*fr)/fr)+','+String(Math.floor(A.x[1].x[2]*fr)/fr)+','+String(Math.floor(A.x[1].x[3]*fr)/fr) +
        '&#13;true,4,'+String(Math.floor(A.x[2].x[0]*fr)/fr)+','+String(Math.floor(A.x[2].x[1]*fr)/fr)+','+String(Math.floor(A.x[2].x[2]*fr)/fr)+','+String(Math.floor(A.x[2].x[3]*fr)/fr) +
        '&#13;true,4,'+String(Math.floor(A.x[3].x[0]*fr)/fr)+','+String(Math.floor(A.x[3].x[1]*fr)/fr)+','+String(Math.floor(A.x[3].x[2]*fr)/fr)+','+String(Math.floor(A.x[3].x[3]*fr)/fr);
  elm.value = str;

  // 再度ラジオボタンの選択状態を確認し、必要であれば逆行列を再計算
  if(radioList[0].checked) {
    A = A.InverseMat(dt);
  }
}

/**
 * ApllyXXXで回転状態を復元するときに呼び出される関数
 * 行列の入力が変更されたときに呼び出される関数。
 * 入力された行列を元にビュー行列を更新し、他の形式の回転情報も更新します。
 */
function chgrotMT(){
  // 'rotMTin'要素から入力された行列文字列を取得
  var elm = document.getElementById('rotMTin');
  var ro = String(elm.value);
  // 'rotMT'要素に同じ値を設定
  elm = document.getElementById('rotMT');
  elm.value = ro;
  // 改行コードをスペースに置換
  ro = ro.replace(/\n/g, " ");
  // 文字列からN6LMatrixオブジェクトをパース
  A = new N6LMatrix().Parse(ro);

  // 'INV'という名前のラジオボタンリストを取得
  var radioList = document.getElementsByName("INV");
  var dt = []; // 逆行列計算時に使用される可能性のある一時変数
  var rot = A.Vector(); // 行列Aから回転ベクトルを計算

  // ラジオボタンの選択状態に基づいて行列Aを設定
  if(radioList[0].checked) { // 最初のラジオボタンがチェックされている場合（おそらく逆行列モード）
    A = rot.Matrix(); // 回転ベクトルから行列を生成
    A = A.InverseMat(dt); // 生成した行列の逆行列を計算
  } else { // それ以外の場合（通常モード）
    A = rot.Matrix(); // 回転ベクトルから行列を生成
  }

  // 更新された行列Aから回転ベクトルを再計算
  rot = A.Vector();
  // 'viewp001'要素のorientation属性をX3DOM形式の回転ベクトルで更新
  elm = document.getElementById('viewp001');
  elm.setAttribute('orientation', rot.ToX3DOM().toString());

  // 'rot'要素に計算された回転ベクトルを設定
  elm = document.getElementById('rot');
  // 回転ベクトルの成分をfrで丸めて文字列に変換
  var str = 'true,4,'+String(Math.floor(rot.x[0]*fr)/fr)+','+String(Math.floor(rot.x[1]*fr)/fr)+','+String(Math.floor(rot.x[2]*fr)/fr)+','+String(Math.floor(rot.x[3]*fr)/fr);
  elm.value = str;

  // 行列Aからオイラー角を計算
  var ea = A.EulerAngle(1,2,3);
  // 'rotEA'要素に計算されたオイラー角を設定
  elm = document.getElementById('rotEA');
  // オイラー角を度数法に変換し、frで丸めて文字列に変換
  var str = String(Math.floor(ea.x[1]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[2]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[3]*(180.0/Math.PI)*fr)/fr);
  elm.value = str;

  // 行列Aからクォータニオンを計算
  var qt = A.Quaternion();
  // 'rotQT'要素に計算されたクォータニオンを設定
  elm = document.getElementById('rotQT');
  // クォータニオンの成分をfrで丸めて文字列に変換
  str = 'true,4,'+String(Math.floor(qt.q.x[0]*fr)/fr)+','+String(Math.floor(qt.q.x[1]*fr)/fr)+','+String(Math.floor(qt.q.x[2]*fr)/fr)+','+String(Math.floor(qt.q.x[3]*fr)/fr);
  elm.value = str;

  // 'rotMT'要素に計算された行列を設定
  elm = document.getElementById('rotMT');
  // 行列の各成分をfrで丸めて、改行コードを含む文字列に変換
  str = 'true,4&#13;true,4,'+String(Math.floor(A.x[0].x[0]*fr)/fr)+','+String(Math.floor(A.x[0].x[1]*fr)/fr)+','+String(Math.floor(A.x[0].x[2]*fr)/fr)+','+String(Math.floor(A.x[0].x[3]*fr)/fr) +
        '&#13;true,4,'+String(Math.floor(A.x[1].x[0]*fr)/fr)+','+String(Math.floor(A.x[1].x[1]*fr)/fr)+','+String(Math.floor(A.x[1].x[2]*fr)/fr)+','+String(Math.floor(A.x[1].x[3]*fr)/fr) +
        '&#13;true,4,'+String(Math.floor(A.x[2].x[0]*fr)/fr)+','+String(Math.floor(A.x[2].x[1]*fr)/fr)+','+String(Math.floor(A.x[2].x[2]*fr)/fr)+','+String(Math.floor(A.x[2].x[3]*fr)/fr) +
        '&#13;true,4,'+String(Math.floor(A.x[3].x[0]*fr)/fr)+','+String(Math.floor(A.x[3].x[1]*fr)/fr)+','+String(Math.floor(A.x[3].x[2]*fr)/fr)+','+String(Math.floor(A.x[3].x[3]*fr)/fr);
  elm.value = str;

  // 再度ラジオボタンの選択状態を確認し、必要であれば逆行列を再計算
  if(radioList[0].checked) {
    A = A.InverseMat(dt);
  }
}

/**
 * 各入力フィールドの値を対応する表示フィールドにコピーする関数。
 */
function copy(){
  var elm = document.getElementById('rot');
  var str = String(elm.value);
  elm = document.getElementById('rotin');
  elm.value = str;

  elm = document.getElementById('rotEA');
  str = String(elm.value);
  elm = document.getElementById('rotEAin');
  elm.value = str;

  var elm = document.getElementById('rotQT');
  var str = String(elm.value);
  elm = document.getElementById('rotQTin');
  elm.value = str;

  var elm = document.getElementById('rotMT');
  var str = String(elm.value);
  elm = document.getElementById('rotMTin');
  elm.value = str;
}

// jQueryのdocument.ready関数: DOMが完全にロードされた後に実行される
jQuery(document).ready(function(){
  TMan.add(); // タイマーマネージャーに新しいタイマーを追加
  // メインループ (GLoop) を50ミリ秒ごとに実行するように設定
  TMan.timer[0].setalerm(function() { GLoop(0); }, 50);
});

var be = true; // 入力フィールドの有効/無効状態を管理するフラグ

/**
 * 入力フィールドの背景色を切り替え、キーボード入力を有効/無効にする関数。
 */
function input(){
  var str;
  if(be) str = 'rgb(255,255,255)'; // 有効な場合は白
  else str = 'rgb(136,136,136)'; // 無効な場合はグレー

  // 各入力フィールドの背景色を設定
  var elm = document.getElementById('rotin');
  elm.style.backgroundColor = str;
  elm = document.getElementById('rotEAin');
  elm.style.backgroundColor = str;
  elm = document.getElementById('rotQTin');
  elm.style.backgroundColor = str;
  elm = document.getElementById('rotMTin');
  elm.style.backgroundColor = str;

  // beフラグを反転
  if(be) be = false;
  else be = true;
  // キーボード入力を有効/無効に設定
  KeyB.setenable(be);
}

/**
 * メインループ関数。
 * X3DOMのビュー行列を取得し、それを元に回転情報を更新し、表示フィールドに反映します。
 * また、タイマーを再設定して継続的に実行されます。
 * @param {number} id - タイマーID
 */
function GLoop(id){
  // X3DOMランタイムがまだ初期化されていない場合は、初期化されるまで待機
  if(x3domRuntime == undefined) {
    x3domRuntime = document.getElementById('x3dabs').runtime; // X3DOMランタイムオブジェクトを取得
    TMan.timer[id].setalerm(function() { GLoop(id); }, 50); // 50ミリ秒後にメインループを再設定
    return;
  }

  var elm = document.getElementById('viewp001'); // 'viewp001'要素を取得

  // X3DOMのビュー行列の逆行列（ワールド回転行列）を取得
  var SWM = x3domRuntime.viewMatrix().inverse();
  // X3DOM行列をN6LMatrixオブジェクトに変換
  A = new N6LMatrix().FromX3DOM(SWM);

  // 'INV'という名前のラジオボタンリストを取得
  var radioList = document.getElementsByName("INV");
  var dt = []; // 逆行列計算時に使用される可能性のある一時変数
  var rot = A.Vector(); // 行列Aから回転ベクトルを計算

  // ラジオボタンの選択状態に基づいて行列Aを設定
  if(radioList[0].checked) { // 最初のラジオボタンがチェックされている場合（おそらく逆行列モード）
    A = rot.Matrix(); // 回転ベクトルから行列を生成
    A = A.InverseMat(dt); // 生成した行列の逆行列を計算
  } else { // それ以外の場合（通常モード）
    A = rot.Matrix(); // 回転ベクトルから行列を生成
  }

  // 行列Aからオイラー角を計算
  var ea = A.EulerAngle(1,2,3);
  // 'rotEA'要素に計算されたオイラー角を設定
  var elm = document.getElementById('rotEA');
  // オイラー角を度数法に変換し、frで丸めて文字列に変換
  var str = String(Math.floor(ea.x[1]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[2]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[3]*(180.0/Math.PI)*fr)/fr);
  elm.value = str;

  // 更新された行列Aから回転ベクトルを再計算
  rot = A.Vector();
  // 'rot'要素に計算された回転ベクトルを設定
  elm = document.getElementById('rot');
  // 回転ベクトルの成分をfrで丸めて文字列に変換
  str = 'true,4,'+String(Math.floor(rot.x[0]*fr)/fr)+','+String(Math.floor(rot.x[1]*fr)/fr)+','+String(Math.floor(rot.x[2]*fr)/fr)+','+String(Math.floor(rot.x[3]*fr)/fr);
  elm.value = str;

  // 行列Aからクォータニオンを計算
  var qt = A.Quaternion();
  // 'rotQT'要素に計算されたクォータニオンを設定
  elm = document.getElementById('rotQT');
  // クォータニオンの成分をfrで丸めて文字列に変換
  str = 'true,4,'+String(Math.floor(qt.q.x[0]*fr)/fr)+','+String(Math.floor(qt.q.x[1]*fr)/fr)+','+String(Math.floor(qt.q.x[2]*fr)/fr)+','+String(Math.floor(qt.q.x[3]*fr)/fr);
  elm.value = str;

  // 'rotMT'要素に計算された行列を設定
  elm = document.getElementById('rotMT');
  // 行列の各成分をfrで丸めて、改行コードを含む文字列に変換
  str = 'true,4\ntrue,4,'+String(Math.floor(A.x[0].x[0]*fr)/fr)+','+String(Math.floor(A.x[0].x[1]*fr)/fr)+','+String(Math.floor(A.x[0].x[2]*fr)/fr)+','+String(Math.floor(A.x[0].x[3]*fr)/fr) +
        '\ntrue,4,'+String(Math.floor(A.x[1].x[0]*fr)/fr)+','+String(Math.floor(A.x[1].x[1]*fr)/fr)+','+String(Math.floor(A.x[1].x[2]*fr)/fr)+','+String(Math.floor(A.x[1].x[3]*fr)/fr) +
        '\ntrue,4,'+String(Math.floor(A.x[2].x[0]*fr)/fr)+','+String(Math.floor(A.x[2].x[1]*fr)/fr)+','+String(Math.floor(A.x[2].x[2]*fr)/fr)+','+String(Math.floor(A.x[2].x[3]*fr)/fr) +
        '\ntrue,4,'+String(Math.floor(A.x[3].x[0]*fr)/fr)+','+String(Math.floor(A.x[3].x[1]*fr)/fr)+','+String(Math.floor(A.x[3].x[2]*fr)/fr)+','+String(Math.floor(A.x[3].x[3]*fr)/fr);
  elm.innerText = str; // innerTextも設定
  elm.value = str; // valueも設定

  // ラジオボタンの選択状態を確認 (ここでは何もしないが、以前のロジックの名残か)
  if(radioList[0].checked) {
    ;
  } else {
    A = A.InverseMat(dt);
  }

  TMan.timer[id].setalerm(function() { GLoop(id); }, 50); // 50ミリ秒後にメインループを再設定
}

/**
 * キーボード入力のチェックと3Dビューの回転を行う関数。
 * テンキーの2, 8, 4, 6, 1, 3を使ってピッチ、ヨー、ロールを調整します。
 */
function chkKeyBoard(){
  var b = false; // キーが押されたかどうかのフラグ
  var p = 0.0; // ピッチ (X軸周り) の変化量
  var y = 0.0; // ヨー (Y軸周り) の変化量
  var r = 0.0; // ロール (Z軸周り) の変化量
  var ad = 0.05; // 回転の増分

  // テンキーの2 (下) が押された場合
  if(KeyB.keystate[KeyB.indexof(KeyB.ToReal('VK_N2'))]) {
    b = true;
    p -= ad; // ピッチを減少
  }
  // テンキーの8 (上) が押された場合
  if(KeyB.keystate[KeyB.indexof(KeyB.ToReal('VK_N8'))]) {
    b = true;
    p += ad; // ピッチを増加
  }
  // テンキーの4 (左) が押された場合
  if(KeyB.keystate[KeyB.indexof(KeyB.ToReal('VK_N4'))]) {
    b = true;
    y -= ad; // ヨーを減少
  }
  // テンキーの6 (右) が押された場合
  if(KeyB.keystate[KeyB.indexof(KeyB.ToReal('VK_N6'))]) {
    b = true;
    y += ad; // ヨーを増加
  }
  // テンキーの1 (左下) が押された場合
  if(KeyB.keystate[KeyB.indexof(KeyB.ToReal('VK_N1'))]) {
    b = true;
    r -= ad; // ロールを減少
  }
  // テンキーの3 (右下) が押された場合
  if(KeyB.keystate[KeyB.indexof(KeyB.ToReal('VK_N3'))]) {
    b = true;
    r += ad; // ロールを増加
  }

  // いずれかのキーが押された場合
  if(b) {
    var dt = []; // 一時変数
    var rot = A.Vector(); // 現在の行列Aから回転ベクトルを取得

    // 行列Aを回転ベクトルから再構築し、その逆行列を取得 (おそらくX3DOMのビュー行列に合わせるため)
    A = rot.Matrix();
    A = A.InverseMat(dt);

    // ピッチ、ヨー、ロールの増分を含む新しいN6LVectorを生成
    var wpyr = new N6LVector([1, p, y, r], true);
    var outmat = []; // 出力行列用
    var outv = []; // 出力ベクトル用

    // 現在の行列Aに回転増分を適用して新しい行列Aを計算
    // MoveMat関数は、移動、回転、スケールなどを適用する汎用関数と思われる
    A = A.MoveMat(outmat, outv, new N6LVector(4, true).ZeroVec(), wpyr, 0, 0, 0, 0); // 目的の関数

    // 更新された行列Aから回転ベクトルを再計算
    rot = A.Vector();
    // 'viewp001'要素のorientation属性をX3DOM形式の回転ベクトルで更新し、3Dビューに反映
    var elm = document.getElementById('viewp001');
    elm.setAttribute('orientation', rot.ToX3DOM().toString());

    // 行列Aの逆行列を再計算 (おそらく内部状態を一致させるため)
    A = A.InverseMat(dt);
  }
};

