﻿import * as THREE from '../threejs/build/three.module.js';


let chk = false;
let fr = 1000;

let A = new N6LMatrix(4).UnitMat(); //mat view // Holds the pure rotation matrix before converting it to a Three.js view matrix (mainly for UI display)
let B = new N6LMatrix(4).UnitMat(); //mat view // Camera world transformation matrix (including position and rotation). Continuously updated and applied to the Three.js camera.
let la = new N6LVector(4, true).UnitVec(3); // lookAt vector (direction the camera is facing)
let up = new N6LVector(4, true).UnitVec(2); // up vector (upward direction of the camera)
let cr = new N6LVector(4, true).UnitVec(1); // right vector (right direction of the camera)
let tr = new N6LVector(4, true).UnitVec(0); // translation vector (position of the camera)
let pos = new N6LVector(4, true).UnitVec(0); // Vector for saving the current position of the camera (mainly used for restoration processing)
let pyr = new N6LVector([1, 0, 0, 0], true); // Accumulated angles of pitch (x), yaw (y), and roll (z) (for keyboard operation)

// Hit init when DOM loading is complete
window.addEventListener("DOMContentLoaded", init);

let renderer;
let camera;
let scene;

//Entry point
function init() {
  initKeyBoard(TMan, function() { chkKeyBoard(); });

  // ボタン要素を取得
  const copyButton = document.getElementById('IDcopy');
  // ボタンが存在すれば、イベントリスナーを追加
  if (copyButton) {
    copyButton.addEventListener('click', () => { copy(); });
  }
  // ボタン要素を取得
  const inputButton = document.getElementById('IDinput');
  // ボタンが存在すれば、イベントリスナーを追加
  if (inputButton) {
    inputButton.addEventListener('click', () => { input(); });
  }
  // ボタン要素を取得
  const chgrotVecButton = document.getElementById('IDchgrotVec');
  // ボタンが存在すれば、イベントリスナーを追加
  if (chgrotVecButton) {
    chgrotVecButton.addEventListener('click', () => { chgrotVec(); });
  }
  // ボタン要素を取得
  const chgrotEAButton = document.getElementById('IDchgrotEA');
  // ボタンが存在すれば、イベントリスナーを追加
  if (chgrotEAButton) {
    chgrotEAButton.addEventListener('click', () => { chgrotEA(); });
  }
  // ボタン要素を取得
  const chgrotQTButton = document.getElementById('IDchgrotQT');
  // ボタンが存在すれば、イベントリスナーを追加
  if (chgrotQTButton) {
    chgrotQTButton.addEventListener('click', () => { chgrotQT(); });
  }
  // ボタン要素を取得
  const chgrotMTButton = document.getElementById('IDchgrotMT');
  // ボタンが存在すれば、イベントリスナーを追加
  if (chgrotMTButton) {
    chgrotMTButton.addEventListener('click', () => { chgrotMT(); });
  }


  const width = 500;
  const height = 500;

  renderer = new THREE.WebGLRenderer({
    canvas: document.querySelector("#cnv0")
  });
  renderer.setPixelRatio(window.devicePixelRatio);
  renderer.setSize(width, height);
  scene = new THREE.Scene();
  camera = new THREE.PerspectiveCamera(45,width / height,1,10000);
  camera.position.set(0, 0, 20);

  // camera.projectionMatrix is ??the Three.js projection matrix. It is converted to NAS6LIB format, but is not used directly in this demo.
  // Mainly for the purpose of initializing B as the camera's world transformation matrix.
  // Ideally, you should initialize B to match camera.position.set(0, 0, 20);.
  // Alternatively, you can initialize B to a pure identity matrix and construct B separately based on camera.position.
  let Proj = camera.projectionMatrix;
  B = B.From3JS(Proj); // Convert Three.js matrix to NAS6LIB format
//  B = B.SetHomo(true); // Set W component of homogeneous coordinate to 1 and normalize

  const geometry = new THREE.BoxGeometry(5, 5, 5);
  const loader = new THREE.TextureLoader();

  const path = "./img/skybox";
  const format = '2.jpg';
  const urls = [
    path + 'px' + format, path + 'nx' + format,
    path + 'py' + format, path + 'ny' + format,
    path + 'pz' + format, path + 'nz' + format
  ];

  const tCube = new THREE.CubeTextureLoader().load( urls );
  scene.background = tCube;

  // Directional light source
  const light = new THREE.DirectionalLight(0xffffff);
  light.intensity = 2; // Double the light intensity
  light.position.set(1, 1, 1);
  // Add to the scene
  scene.add(light);
  const alight = new THREE.AmbientLight( '#808080' );
  scene.add( alight );

  // Get the canvas element that creates the Three.js renderer
  // Example: document.getElementById('myCanvas') or renderer.domElement
  const canvasMS = renderer.domElement;

  let mouseX = 0;
  let mouseY = 0;

  let isDragging = false;
  let previousMouseX = 0;
  let previousMouseY = 0;

  canvasMS.addEventListener('mousedown', (event) => {
    if (event.button === 0) { // Left click (button === 0) 
      isDragging = true; 
      const rect = canvasMS.getBoundingClientRect(); 
      previousMouseX = event.pageX - rect.left; 
      previousMouseY = event.pageY - rect.top; 
    } 
  });
  canvasMS.addEventListener('mousemove', (event) => {
    if (isDragging) {
      const rect = canvasMS.getBoundingClientRect();
      const currentMouseX = event.pageX - rect.left;
      const currentMouseY = event.pageY - rect.top;

      // Camera yaw and pitch sensitivity adjustment. Radians per 1px
      const rotationSpeed = 0.005;

      // Mouse horizontal movement deltaX corresponds to camera yaw (around Y axis) rotation,
      // Mouse vertical movement deltaY corresponds to camera pitch (around X axis) rotation.
      // Sign is adjusted to match Three.js coordinate system and mouse operation direction.
      // Mouse delta (movement)
      const deltaX = currentMouseX - previousMouseX;
      const deltaY = currentMouseY - previousMouseY;

      // Calculate yaw and pitch angles
      // In Three.js, the Y axis is upwards, so pay attention to the sign of deltaY to match the up and down movement of the mouse with the pitch direction.

      const yawAngle = -deltaX * rotationSpeed; // Rotate around the Y axis (upward) when moving left and right
      const pitchAngle = -deltaY * rotationSpeed; // Rotate around the X axis (horizontal) when moving up and down

      // Temporarily copy the camera's world matrix (B),
      // Treat it as a view matrix (camera perspective) or world matrix (object perspective) by taking the inverse matrix as necessary
      //Camera world matrix
      let matWK = new N6LMatrix(B);
      let radioList = document.getElementsByName("INV"); // Inverts depending on the state of the "INV" radio button
      let dt = []; // Dummy letiable for the InverseMat function (can be deleted if not used)
      if(radioList[0].checked) {
        ;// If radioList[0] is checked, matWK is treated as the camera's world matrix.
      } else {
        // If radioList[0] is not checked, convert matWK to the view matrix (inverse matrix).
        matWK = matWK.InverseMat(dt);
      }

      // Get the camera's current local axes (X, Y, Z) from matWK.
      // These axes are based on the camera's current orientation, allowing accurate rotation at any pose.
      // Note the correspondence between N6LMatrix indexes and axes (e.g. x[3] is the Z axis, x[2] is the Y axis).
      // Three.js uses a column-major matrix (mat.elements[0] is the X component of the X axis).
      // Get the axis assuming that NAS6LIB's N6LMatrix.x[index] returns a column vector.
      // az = new N6LVector(matWK.x[2]); // Camera Z axis (forward) - Three.js Z axis (col 2)
      // ay = new N6LVector(matWK.x[1]); // Camera Y axis (up) - Three.js Y axis (col 1)
      // ax = ay.Cross(az); // Camera X axis (right) - In a right-handed system, the cross product of the Y and Z axes is the X axis
      // The order is different between 3JS and NAS6LIB as shown above
      let az = new N6LVector(matWK.x[3]); // Camera Z axis (forward)
      az = az.SetHomo(true);
      let ay = new N6LVector(matWK.x[2]); // Camera Y axis (up)
      ay = ay.SetHomo(true);
      let ax = az.Cross(ay); // Camera X axis (right). Right-handed system: (forward x up) = left, (up x forward) = Right. Matches NAS6LIB's Cross implementation.
      ax = ax.SetHomo(true);

      // Apply yaw rotation (around Y axis)
      // matWK uses quaternions internally, avoiding gimbal lock issues
      matWK = matWK.RotAxis(ay, yawAngle * 1.0);

      // ★IMPORTANT: Since matWK has been updated by the yaw rotation, recalculate the local axis as well.
      // This ensures that the next pitch rotation is around the correct X axis of the current camera.
      // (Not necessary for small angles, but required to avoid glitches (twisting) at large angles or with continuous operations)
      az = new N6LVector(matWK.x[3]);
      az = az.SetHomo(true);
      ay = new N6LVector(matWK.x[2]);
      ay = ay.SetHomo(true);
      ax = az.Cross(ay);
      ax = ax.SetHomo(true);

      // Apply pitch rotation (around X axis)
      matWK = matWK.RotAxis(ax, pitchAngle * -1.0);

      matWK = matWK.NormalMat(); // Normalize matrix (to avoid scale/shear accumulation)

      //update
      if(radioList[0].checked) {
        ;
      }
      else {
        matWK = matWK.InverseMat(dt);
      }
      // matWK = matWK.SetCol(0,new N6LVector([1,1,1,1])); // This line may not be needed for some purposes
      matWK = matWK.SetCol(0,new N6LVector([1,0,0,0])); // This line may not be needed for some purposes
      // matWK = matWK.SetHomo(true); // Normalize W component

      // Save final camera world matrix in B
      B = new N6LMatrix(matWK);

      previousMouseX = currentMouseX;
      previousMouseY = currentMouseY;
    }
  });

  canvasMS.addEventListener('mouseup', (event) => {
    if (event.button === 0) {
      isDragging = false;
    }
  });

  // It's more robust if you also add a mouseup event to the window in case you release the mouse outside the canvas
  window.addEventListener('mouseup', () => {
    isDragging = false;
  });

  TimerID = TMan.add();
  Loop(TimerID);

  //main loop//Main loop
  function Loop(id){

    //Camera world matrix
    let matWK = new N6LMatrix(B);
    let radioList = document.getElementsByName("INV");
    let dt = [];
    if(radioList[0].checked) {
      ;
    }
    else {
      matWK = matWK.InverseMat(dt);
    }

    let az = new N6LVector(matWK.x[3]); //Camera Z-axis row
    az = az.SetHomo(true);
    let ay = new N6LVector(matWK.x[2]); //Camera Y-axis row
    ay = ay.SetHomo(true);
    let ax = az.Cross(ay); //Camera X-axis row
    ax = ax.SetHomo(true);

    // ... (Axis acquisition and rotation processing almost the same as in the mousemove event) ...

    // Yaw pitch roll rotation (rotation based on input value from text box)
    // The loop function applies the accumulated value of pyr as a small angle every frame,
    // Since omitting to reacquire the axis after each rotation is unlikely to cause any problems (in appearance).
    // However, strictly speaking, it is most accurate to update the axis sequentially, as with mousemove.
    // matWK = matWK.RotAxis(az, pyr.x[3] * -1.0); // Roll (around Z axis)
    matWK = matWK.RotAxis(ay, pyr.x[2] * -1.0); // Yaw (around Y axis)
    matWK = matWK.RotAxis(ax, pyr.x[1] * -1.0); // Pitch (around X axis)
    matWK = matWK.NormalMat();
    //update
    if(radioList[0].checked) {
      ;
    } else {
      matWK = matWK.InverseMat(dt);
    }
//    matWK = matWK.SetCol(0,new N6LVector([1,1,1,1]));
    matWK = matWK.SetCol(0,new N6LVector([1,0,0,0]));
//    matWK = matWK.SetHomo(true);
    B = new N6LMatrix(matWK);
    tr = new N6LVector(matWK.x[0]);
    tr = tr.SetHomo(true);
    up = new N6LVector(matWK.x[2]);
    up = up.SetHomo(true);
    la = new N6LVector(matWK.x[3]);
    la = la.SetHomo(true);
    A = matWK.TransposedMat().TranslatedMat(tr.Mul(-1)).ScaleMat(new N6LVector([1,1,1,-1],true)).TransposedMat();
    //This is for updating the output text box, so it may be better to insert the homogeneous element w=1
//    A = A.SetCol(0,new N6LVector([1,1,1,1]));
    A = A.SetCol(0,new N6LVector([1,0,0,0]));
//    A = A.SetHomo(true);

    let rot = matWK.Vector();
    //reset
    pyr = new N6LVector([1, 0, 0, 0], true); 


    //Get rotation information and update text box 
    let ea = A.EulerAngle(1,2,3); 
    let elm = document.getElementById('rotEA'); 
    let sss = String(Math.floor(ea.x[1]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[2]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[3]*(180.0/Math.PI)*fr)/fr); 
    elm.value = sss; 

    rot = A.Vector(); 
    elm = document.getElementById('rot'); 
    sss = 'true,4,'+String(Math.floor(rot.x[0]*fr)/fr)+','+String(Math.floor(rot.x[1]*fr)/fr)+','+String(Math.floor(rot.x[2]*fr)/fr)+','+String(Math.floor(rot.x[3]*fr)/fr); 
    elm.value = sss; 

    let qt = A.Quaternion(); 
    elm = document.getElementById('rotQT'); 
    sss = 'true,4,'+String(Math.floor(qt.q.x[0]*fr)/fr)+','+String(Math.floor(qt.q.x[1]*fr)/fr)+','+String(Math.floor(qt.q.x[2]*fr)/fr)+','+String(Math.floor(qt.q.x[3]*fr)/fr); 
    elm.value = sss; 

    elm = document.getElementById('rotMT'); 
    sss = 'true,4\ntrue,4,'+String(Math.floor(A.x[0].x[0]*fr)/fr)+','+String(Math.floor(A.x[0].x[1]* fr)/fr)+','+String(Math.floor(A.x[0].x[2]*fr)/fr)+','+String(Math.floor(A.x[0].x[3]*fr)/fr) + '\ntrue,4,'+String(Math.floor(A.x[1].x[0]*fr)/fr)+','+String(Math.floor(A.x[1].x[1]*fr) /fr)+','+String(Math.floor(A.x[1].x[2]*fr)/fr)+','+String(Math.floor(A.x[1].x[3]*fr)/fr) + '\ntrue,4,'+String(Math.floor(A.x[2].x[0]*fr)/fr)+','+String(Math.floor(A.x[2].x[1]*fr) /fr)+','+String(Math.floor(A.x[2].x[2]*fr)/fr)+','+String(Math.floor(A.x[2].x[3]*fr)/fr) + '\ntrue,4,'+String(Math.floor(A.x[3].x[0]*fr)/fr)+','+String(Math.floor(A.x[3].x[1]*fr)/fr)+','+String(Math.floor(A.x[3].x[2]*fr)/fr)+','+String(Math.floor(A.x[3].x[3]*fr)/fr);
    elm.innerText = sss;
    elm.value = sss;

    // A is a pure rotation matrix for UI display, and only the rotation part is extracted from B (including position information)
    // Extract the information required by Three.js from the NAS6LIB matrix to set it to the Three.js camera
    // (tr: position, up: up vector, la: focus point (lookAt) vector)
    camera.position.set(tr.x[1], tr.x[2], tr.x[3]); // The order of NAS6L vectors is W, X, Y, Z, so it maps to Three.js's X, Y, Z
    camera.up.set(up.x[1], up.x[2], up.x[3]); // The order of NAS6L vectors is W, X, Y, Z, so it maps to Three.js's X, Y, Z
    camera.lookAt(la.x[1], la.x[2], la.x[3]); // The order of NAS6L vectors is W, X, Y, Z, so it maps to Three.js's X, Y, Z

    // Render
    renderer.render(scene, camera);

    TMan.timer[id].setalerm(function() { Loop(id); }, 50); // Main loop set
  }

}

//Restore the rotation below
function chgrotVec(){ 
  let elm = document.getElementById('rotin'); 
  let ro = String(elm.value); 
  elm = document.getElementById('rot'); 
  elm.value = ro; 
  let rot = new N6LVector().Parse(ro); 
  let radioList = document.getElementsByName("INV"); 
  let dt = []; 
  if(radioList[0].checked) { 
    A = rot.Matrix(); 
//    A = A.SetCol(0,new N6LVector([1,1,1,1])); 
    A = A.SetCol(0,new N6LVector([1,0,0,0])); 
//    A = A.SetHomo(true); 
  } 
  else { 
    A = rot.Matrix(); 
//    A = A.SetCol(0,new N6LVector([1,1,1,1])); 
    A = A.SetCol(0,new N6LVector([1,0,0,0])); 
//    A = A.SetHomo(true); 
    A = A.InverseMat(dt); 
  } 
  B = new N6LMatrix([pos,A.x[1],A.x[2],A.x[3].Mul(-1)]); 
  B.x[3].x[0] = 1.0; 
  pos = new N6LVector(B.x[0]); 

  elm = document.getElementById('rot'); 
  let ea = A.EulerAngle(1,2,3); 
  elm = document.getElementById('rotEA'); 
  let sss = String(Math.floor(ea.x[1]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[2]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[3]*(180.0/Math.PI)*fr)/fr); 
  elm.value = sss; 
  let qt = A.Quaternion(); 
  elm = document.getElementById('rotQT'); 
  sss = 'true,4,'+String(Math.floor(qt.q.x[0]*fr)/fr)+','+String(Math.floor(qt.q.x[1]*fr)/fr)+','+String(Math.floor(qt.q.x[2]*fr)/fr)+','+String(Math.floor(qt.q.x[3]*fr)/fr); 
  elm.value = sss; 
  elm = document.getElementById('rotMT'); 
  sss = 'true,4&#13;true,4,'+String(Math.floor(A.x[0].x[0]*fr)/fr)+','+String(Math.floor(A.x[0].x[1] *fr)/fr)+','+String(Math.floor(A.x[0].x[2]*fr)/fr)+','+String(Math.floor(A.x[0].x[3]*fr)/fr) + '&#13;true,4,'+String(Math.floor(A.x[1].x[0]*fr)/fr)+','+String(Math.floor(A.x[1].x[1]*fr )/fr)+','+String(Math.floor(A.x[1].x[2]*fr)/fr)+','+String(Math.floor(A.x[1].x[3]*fr)/fr) + '&#13;true,4,'+String(Math.floor(A.x[2].x[0]*fr)/fr)+','+String(Math.floor(A.x[2].x[1]*fr )/fr)+','+String(Math.floor(A.x[2].x[2]*fr)/fr)+','+String(Math.floor(A.x[2].x[3]*fr)/fr) + '&#13;true,4,'+String(Math.floor(A.x[3].x[0]*fr)/fr)+','+String(Math.floor(A.x[3].x[1]*fr )/fr)+','+String(Math.floor(A.x[3].x[2]*fr)/fr)+','+String(Math.floor(A.x[3].x[3]*fr)/fr); 
  elm.value = sss;
}

function chgrotEA(){ 
  let elm = document.getElementById('rotEAin'); 
  let roEA = String(elm.value); 
  elm = document.getElementById('rotEA'); 
  elm.value = roEA; 
  let tk = roEA.split(','); 
  let ea = new N6LVector([1,Number(tk[0])*(Math.PI/180.0),Number(tk[1])*(Math.PI/180.0),Number(tk[2])*(Math.PI/180.0)],true); 
  let ax = new N6LVector(4,true).UnitVec(1); 
  let ay = new N6LVector(4,true).UnitVec(2); 
  let az = new N6LVector(4,true).UnitVec(3); 
  A = A.UnitMat().RotAxis(ax,ea.x[1]); 
  ay = A.GetRow(2); 
  A = A.RotAxis(ay,ea.x[2]); 
  az = A.GetRow(3); 
  A = A.RotAxis(az,ea.x[3]); 
//  A = A.SetCol(0,new N6LVector([1,1,1,1])); 
  A = A.SetCol(0,new N6LVector([1,0,0,0])); 
//  A = A.SetHomo(true); 
  let radioList = document.getElementsByName("INV"); 
  let dt = []; 
  if(radioList[0].checked) { 
    ; 
  } 
  else { 
    A = A.InverseMat(dt); 
  } 
  B = new N6LMatrix([pos,A.x[1],A.x[2],A.x[3].Mul(-1)]); 
  B.x[3].x[0] = 1.0; 
  pos = new N6LVector(B.x[0]); 

  elm = document.getElementById('rot'); 
  let rot = A.Vector(); 
  let sss = 'true,4,'+String(Math.floor(rot.x[0]*fr)/fr)+','+String(Math.floor(rot.x[1]*fr)/fr)+','+String(Math.floor(rot.x[2]*fr)/fr)+','+String(Math.floor(rot.x[3]*fr)/fr); 
  elm.value = sss; 
  let qt = A.Quaternion(); 
  elm = document.getElementById('rotQT'); 
  sss = 'true,4,'+String(Math.floor(qt.q.x[0]*fr)/fr)+','+String(Math.floor(qt.q.x[1]*fr)/fr)+','+String(Math.floor(qt.q.x[2]*fr)/fr)+','+String(Math.floor(qt.q.x[3]*fr)/fr); 
  elm.value = sss; 
  elm = document.getElementById('rotMT'); 
  sss = 'true,4&#13;true,4,'+String(Math.floor(A.x[0].x[0]*fr)/fr)+','+String(Math.floor(A.x[0].x[1] *fr)/fr)+','+String(Math.floor(A.x[0].x[2]*fr)/fr)+','+String(Math.floor(A.x[0].x[3]*fr)/fr) + '&#13;true,4,'+String(Math.floor(A.x[1].x[0]*fr)/fr)+','+String(Math.floor(A.x[1].x[1]*fr )/fr)+','+String(Math.floor(A.x[1].x[2]*fr)/fr)+','+String(Math.floor(A.x[1].x[3]*fr)/fr) + '&#13;true,4,'+String(Math.floor(A.x[2].x[0]*fr)/fr)+','+String(Math.floor(A.x[2].x[1]*fr )/fr)+','+String(Math.floor(A.x[2].x[2]*fr)/fr)+','+String(Math.floor(A.x[2].x[3]*fr)/fr) + '&#13;true,4,'+String(Math.floor(A.x[3].x[0]*fr)/fr)+','+String(Math.floor(A.x[3].x[1]*fr )/fr)+','+String(Math.floor(A.x[3].x[2]*fr)/fr)+','+String(Math.floor(A.x[3].x[3]*fr)/fr); 
  elm.value = sss;
}

function chgrotQT(){ 
  let elm = document.getElementById('rotQTin'); 
  let ro = String(elm.value); 
  elm = document.getElementById('rotQT'); 
  elm.value = ro; 
  let qt = new N6LQuaternion().Parse(ro); 
  let dt = []; 
  A = qt.Matrix(); 
//  A = A.SetCol(0,new N6LVector([1,1,1,1])); 
  A = A.SetCol(0,new N6LVector([1,0,0,0])); 
//  A = A.SetHomo(true); 
  let radioList = document.getElementsByName("INV"); 
  if(radioList[0].checked) { 
    ; 
  } 
  else { 
    A = A.InverseMat(dt); 
  } 
  B = new N6LMatrix([pos,A.x[1],A.x[2],A.x[3].Mul(-1)]); 
  B.x[3].x[0] = 1.0; 
  pos = new N6LVector(B.x[0]); 

  elm = document.getElementById('rot'); 
  let rot = A.Vector(); 
  let sss = 'true,4,'+String(Math.floor(rot.x[0]*fr)/fr)+','+String(Math.floor(rot.x[1]*fr)/fr)+','+String(Math.floor(rot.x[2]*fr)/fr)+','+String(Math.floor(rot.x[3]*fr)/fr); 
  elm.value = sss; 
  let ea = A.EulerAngle(1,2,3); 
  elm = document.getElementById('rotEA'); 
  sss = String(Math.floor(ea.x[1]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[2]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[3]*(180.0/Math.PI)*fr)/fr); 
  elm.value = sss; 
  elm = document.getElementById('rotQT'); 
  sss = 'true,4,'+String(Math.floor(qt.q.x[0]*fr)/fr)+','+String(Math.floor(qt.q.x[1]*fr)/fr)+','+String(Math.floor(qt.q.x[2]*fr)/fr)+','+String(Math.floor(qt.q.x[3]*fr)/fr); 
  elm.value = sss; 
  elm = document.getElementById('rotMT'); 
  sss = 'true,4&#13;true,4,'+String(Math.floor(A.x[0].x[0]*fr)/fr)+','+String(Math.floor(A.x[0].x[1] *fr)/fr)+','+String(Math.floor(A.x[0].x[2]*fr)/fr)+','+String(Math.floor(A.x[0].x[3]*fr)/fr) + '&#13;true,4,'+String(Math.floor(A.x[1].x[0]*fr)/fr)+','+String(Math.floor(A.x[1].x[1]*fr )/fr)+','+String(Math.floor(A.x[1].x[2]*fr)/fr)+','+String(Math.floor(A.x[1].x[3]*fr)/fr) + '&#13;true,4,'+String(Math.floor(A.x[2].x[0]*fr)/fr)+','+String(Math.floor(A.x[2].x[1]*fr )/fr)+','+String(Math.floor(A.x[2].x[2]*fr)/fr)+','+String(Math.floor(A.x[2].x[3]*fr)/fr) + '&#13;true,4,'+String(Math.floor(A.x[3].x[0]*fr)/fr)+','+String(Math.floor(A.x[3].x[1]*fr )/fr)+','+String(Math.floor(A.x[3].x[2]*fr)/fr)+','+String(Math.floor(A.x[3].x[3]*fr)/fr); 
  elm.value = sss;
}

function chgrotMT(){ 
  let elm = document.getElementById('rotMTin'); 
  let ro = String(elm.value); 
  elm = document.getElementById('rotMT'); 
  elm.value = ro; 
  ro = ro.replace(/\n/g, " "); 
  A = new N6LMatrix().Parse(ro); 
//  A = A.SetCol(0,new N6LVector([1,1,1,1])); 
  A = A.SetCol(0,new N6LVector([1,0,0,0])); 
//  A = A.SetHomo(true); 
  let radioList = document.getElementsByName("INV"); 
  let dt = []; 
  if(radioList[0].checked) { 
    ; 
  } 
  else { 
    A = A.InverseMat(dt); 
  } 
  B = new N6LMatrix([pos,A.x[1],A.x[2],A.x[3].Mul(-1)]); 
  B.x[3].x[0] = 1.0; 
  pos = new N6LVector(B.x[0]); 

  elm = document.getElementById('rot'); 
  let rot = A.Vector(); 
  let sss = 'true,4,'+String(Math.floor(rot.x[0]*fr)/fr)+','+String(Math.floor(rot.x[1]*fr)/fr)+','+String(Math.floor(rot.x[2]*fr)/fr)+','+String(Math.floor(rot.x[3]*fr)/fr); 
  elm.value = sss; 
  let ea = A.EulerAngle(1,2,3); 
  elm = document.getElementById('rotEA'); 
  sss = String(Math.floor(ea.x[1]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[2]*(180.0/Math.PI)*fr)/fr)+','+String(Math.floor(ea.x[3]*(180.0/Math.PI)*fr)/fr); 
  elm.value = sss; 
  let qt = A.Quaternion(); 
  elm = document.getElementById('rotQT'); 
  sss = 'true,4,'+String(Math.floor(qt.q.x[0]*fr)/fr)+','+String(Math.floor(qt.q.x[1]*fr)/fr)+','+String(Math.floor(qt.q.x[2]*fr)/fr)+','+String(Math.floor(qt.q.x[3]*fr)/fr); 
  elm.value = sss; 
  elm = document.getElementById('rotMT'); 
  sss = 'true,4&#13;true,4,'+String(Math.floor(A.x[0].x[0]*fr)/fr)+','+String(Math.floor(A.x[0].x[1] *fr)/fr)+','+String(Math.floor(A.x[0].x[2]*fr)/fr)+','+String(Math.floor(A.x[0].x[3]*fr)/fr) + '&#13;true,4,'+String(Math.floor(A.x[1].x[0]*fr)/fr)+','+String(Math.floor(A.x[1].x[1]*fr )/fr)+','+String(Math.floor(A.x[1].x[2]*fr)/fr)+','+String(Math.floor(A.x[1].x[3]*fr)/fr) + '&#13;true,4,'+String(Math.floor(A.x[2].x[0]*fr)/fr)+','+String(Math.floor(A.x[2].x[1]*fr )/fr)+','+String(Math.floor(A.x[2].x[2]*fr)/fr)+','+String(Math.floor(A.x[2].x[3]*fr)/fr) + '&#13;true,4,'+String(Math.floor(A.x[3].x[0]*fr)/fr)+','+String(Math.floor(A.x[3].x[1]*fr)/fr)+','+String(Math.floor(A.x[3].x[2]*fr)/fr)+','+String(Math.floor(A.x[3].x[3]*fr)/fr);
  elm.value = sss;
}

//Copy information from output text box to input
function copy(){
  let elm = document.getElementById('rot');
  let sss = String(elm.value);
  elm = document.getElementById('rotin');
  elm.value = sss;
  elm = document.getElementById('rotEA');
  sss = String(elm.value);
  elm = document.getElementById('rotEAin');
  elm.value = sss;
  elm = document.getElementById('rotQT');
  sss = String(elm.value);
  elm = document.getElementById('rotQTin');
  elm.value = sss;
  elm = document.getElementById('rotMT');
  sss = String(elm.value);
  elm = document.getElementById('rotMTin');
  elm.value = sss;
  pos = new N6LVector(B.x[0]);
}

//Input state transition (distributing camera movement input and text box input)
let be = true;
function input(){
  let sss;
  if(be) sss = 'rgb(255,255,255)'; 
  else sss = 'rgb(136,136,136)'; 
  let elm = document.getElementById('rotin'); 
  elm.style.backgroundColor = sss; 
  elm = document.getElementById('rotEAin'); 
  elm.style.backgroundColor = sss; 
  elm = document.getElementById('rotQTin'); 
  elm.style.backgroundColor = sss; 
  elm = document.getElementById('rotMTin'); 
  elm.style.backgroundColor = sss; 
  if(be) be = false; 
  else be = true; 
  KeyB.setenable(be);
}

//key input
function chkKeyBoard(){
  if(KeyB.keystate[KeyB.indexof(KeyB.ToReal('VK_N1'))]) {//N1Key 
    pyr.x[3] -= 5 * (Math.PI / 180); 
  } 
  if(KeyB.keystate[KeyB.indexof(KeyB.ToReal('VK_N2'))]) {//N2Key 
    pyr.x[1] += 5 * (Math.PI / 180); 
  } 
  if(KeyB.keystate[KeyB.indexof(KeyB.ToReal('VK_N3'))]) {//N3Key 
    pyr.x[3] += 5 * (Math.PI / 180); 
  } 
  if(KeyB.keystate[KeyB.indexof(KeyB.ToReal('VK_N4'))]) {//N4Key 
    pyr.x[2] += 5 * (Math.PI / 180); 
  } 
  if(KeyB.keystate[KeyB.indexof(KeyB.ToReal('VK_N6'))]) {//N6Key 
    pyr.x[2] -= 5 * (Math.PI / 180); 
  } 
  if(KeyB.keystate[KeyB.indexof(KeyB.ToReal('VK_N8'))]) {//N8Key 
    pyr.x[1] -= 5 * (Math.PI / 180);
  }
}




